/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.io.resource.IWritableResource;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;

@Immutable
public final class TransformResultFactory {
    private static final TransformResultFactory INSTANCE = new TransformResultFactory();

    private TransformResultFactory() {
    }

    @Nonnull
    public static StreamResult create(@Nonnull File file) {
        return new StreamResult(file);
    }

    @Nonnull
    public static StreamResult create(@Nonnull Path path) {
        return new StreamResult(path.toFile());
    }

    @Nonnull
    public static StreamResult create(@Nonnull IWritableResource iWritableResource) {
        return new StreamResult(iWritableResource.getAsFile());
    }

    @Nonnull
    public static StreamResult create(@Nullable @WillNotClose OutputStream outputStream) {
        return new StreamResult(outputStream);
    }

    @Nonnull
    public static StreamResult create(@Nullable @WillNotClose Writer writer) {
        return new StreamResult(writer);
    }

    @Nonnull
    public static DOMResult create(@Nullable Node node) {
        return new DOMResult(node);
    }
}

