/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.exception.InitializationException;
import com.helger.xml.EXMLParserFeature;
import com.helger.xml.EXMLVersion;
import com.helger.xml.serialize.read.DOMReaderDefaultSettings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.SAXException;

public final class XMLFactory {
    public static final boolean DEFAULT_DOM_NAMESPACE_AWARE = true;
    public static final boolean DEFAULT_DOM_VALIDATING = false;
    public static final boolean DEFAULT_DOM_IGNORING_ELEMENT_CONTENT_WHITESPACE = false;
    public static final boolean DEFAULT_DOM_EXPAND_ENTITY_REFERENCES = true;
    public static final boolean DEFAULT_DOM_IGNORING_COMMENTS = true;
    public static final boolean DEFAULT_DOM_COALESCING = true;
    public static final boolean DEFAULT_DOM_XINCLUDE_AWARE = false;
    public static final boolean DEFAULT_SAX_NAMESPACE_AWARE = true;
    public static final boolean DEFAULT_SAX_VALIDATING = false;
    public static final boolean DEFAULT_SAX_XINCLUDE_AWARE = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLFactory.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static DocumentBuilderFactory s_aDefaultDocBuilderFactory;
    @GuardedBy(value="RW_LOCK")
    private static DocumentBuilder s_aDefaultDocBuilder;
    private static final XMLFactory INSTANCE;

    public static void reinitialize() {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultDocBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
            s_aDefaultDocBuilder = null;
        });
    }

    private XMLFactory() {
    }

    private static void _setFeature(@Nonnull DocumentBuilderFactory documentBuilderFactory, @Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        try {
            documentBuilderFactory.setFeature(eXMLParserFeature.getName(), bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOGGER.warn("Failed to set feature " + eXMLParserFeature + " to " + bl + " on XML DocumentBuilderFactory: " + parserConfigurationException.getMessage());
        }
    }

    @Nonnull
    public static DocumentBuilderFactory createDefaultDocumentBuilderFactory() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        XMLFactory._setFeature(documentBuilderFactory, EXMLParserFeature.DISALLOW_DOCTYPE_DECL, true);
        XMLFactory._setFeature(documentBuilderFactory, EXMLParserFeature.EXTERNAL_GENERAL_ENTITIES, false);
        XMLFactory._setFeature(documentBuilderFactory, EXMLParserFeature.EXTERNAL_PARAMETER_ENTITIES, false);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setIgnoringElementContentWhitespace(false);
        documentBuilderFactory.setExpandEntityReferences(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            documentBuilderFactory.setXIncludeAware(false);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return documentBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilderFactory createDocumentBuilderFactory(@Nonnull Schema schema) {
        ValueEnforcer.notNull((Object)schema, (String)"Schema");
        DocumentBuilderFactory documentBuilderFactory = XMLFactory.createDefaultDocumentBuilderFactory();
        documentBuilderFactory.setSchema(schema);
        return documentBuilderFactory;
    }

    @Nonnull
    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return (DocumentBuilderFactory)RW_LOCK.readLockedGet(() -> s_aDefaultDocBuilderFactory);
    }

    @Nonnull
    public static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = (DocumentBuilder)RW_LOCK.readLockedGet(() -> s_aDefaultDocBuilder);
        if (documentBuilder != null) {
            return documentBuilder;
        }
        return (DocumentBuilder)RW_LOCK.writeLockedGet(() -> {
            DocumentBuilder documentBuilder = s_aDefaultDocBuilder;
            if (documentBuilder == null) {
                documentBuilder = s_aDefaultDocBuilder = XMLFactory.createDocumentBuilder(s_aDefaultDocBuilderFactory);
            }
            return documentBuilder;
        });
    }

    @Nonnull
    public static DOMImplementation getDOMImplementation() {
        return XMLFactory.getDocumentBuilder().getDOMImplementation();
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder() {
        return XMLFactory.createDocumentBuilder(XMLFactory.getDocumentBuilderFactory());
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder(@Nonnull Schema schema) {
        return XMLFactory.createDocumentBuilder(XMLFactory.createDocumentBuilderFactory(schema));
    }

    @Nonnull
    public static DocumentBuilder createDocumentBuilder(@Nonnull DocumentBuilderFactory documentBuilderFactory) {
        ValueEnforcer.notNull((Object)documentBuilderFactory, (String)"DocBuilderFactory");
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(DOMReaderDefaultSettings.getErrorHandler());
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new InitializationException("Failed to create document builder", (Throwable)parserConfigurationException);
        }
    }

    @Nonnull
    public static Document newDocument() {
        return XMLFactory.newDocument(XMLFactory.getDocumentBuilder(), null);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder) {
        return XMLFactory.newDocument(documentBuilder, null);
    }

    @Nonnull
    public static Document newDocument(@Nullable EXMLVersion eXMLVersion) {
        return XMLFactory.newDocument(XMLFactory.getDocumentBuilder(), eXMLVersion);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder, @Nullable EXMLVersion eXMLVersion) {
        ValueEnforcer.notNull((Object)documentBuilder, (String)"DocBuilder");
        Document document = documentBuilder.newDocument();
        document.setXmlVersion((eXMLVersion != null ? eXMLVersion : EXMLVersion.XML_10).getVersion());
        return document;
    }

    @Nonnull
    public static Document newDocument(@Nonnull String string, @Nullable String string2, @Nullable String string3) {
        return XMLFactory.newDocument(null, string, string2, string3);
    }

    @Nonnull
    public static Document newDocument(@Nullable EXMLVersion eXMLVersion, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        return XMLFactory.newDocument(XMLFactory.getDocumentBuilder(), eXMLVersion, string, string2, string3);
    }

    @Nonnull
    public static Document newDocument(@Nonnull DocumentBuilder documentBuilder, @Nullable EXMLVersion eXMLVersion, @Nonnull String string, @Nullable String string2, @Nullable String string3) {
        ValueEnforcer.notNull((Object)documentBuilder, (String)"DocBuilder");
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        DocumentType documentType = dOMImplementation.createDocumentType(string, string2, string3);
        Document document = dOMImplementation.createDocument(string3, string, documentType);
        document.setXmlVersion((eXMLVersion != null ? eXMLVersion : EXMLVersion.XML_10).getVersion());
        return document;
    }

    private static void _setFeature(@Nonnull SAXParserFactory sAXParserFactory, @Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        try {
            sAXParserFactory.setFeature(eXMLParserFeature.getName(), bl);
        }
        catch (ParserConfigurationException | SAXException exception) {
            LOGGER.warn("Failed to set feature " + eXMLParserFeature + " to " + bl + " on XML SAXParserFactory: " + exception.getMessage());
        }
    }

    @Nonnull
    public static SAXParserFactory createDefaultSAXParserFactory() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newDefaultInstance();
        XMLFactory._setFeature(sAXParserFactory, EXMLParserFeature.DISALLOW_DOCTYPE_DECL, true);
        XMLFactory._setFeature(sAXParserFactory, EXMLParserFeature.EXTERNAL_GENERAL_ENTITIES, false);
        XMLFactory._setFeature(sAXParserFactory, EXMLParserFeature.EXTERNAL_PARAMETER_ENTITIES, false);
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setXIncludeAware(false);
        return sAXParserFactory;
    }

    private static void _setFeature(@Nonnull TransformerFactory transformerFactory, @Nonnull EXMLParserFeature eXMLParserFeature, boolean bl) {
        try {
            transformerFactory.setFeature(eXMLParserFeature.getName(), bl);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            LOGGER.warn("Failed to set feature " + eXMLParserFeature + " to " + bl + " on XML TransformerFactory: " + transformerConfigurationException.getMessage());
        }
    }

    @Nonnull
    public static TransformerFactory createDefaultTransformerFactory() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            return transformerFactory;
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new InitializationException("Failed to create XML TransformerFactory", (Throwable)transformerFactoryConfigurationError);
        }
    }

    static {
        XMLFactory.reinitialize();
        INSTANCE = new XMLFactory();
    }
}

