/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.locale;

import com.helger.commons.ValueEnforcer;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class LocaleParser {
    private static final LocaleParser INSTANCE = new LocaleParser();

    private LocaleParser() {
    }

    @Nullable
    public static Number parse(String string, @Nonnull Locale locale) {
        return LocaleParser.parse(string, locale, (Number)null);
    }

    @Nullable
    public static Number parse(String string, @Nonnull Locale locale, @Nullable Number number) {
        return LocaleParser.parse(string, NumberFormat.getInstance(locale), number);
    }

    @Nullable
    public static Number parse(@Nullable String string, @Nonnull NumberFormat numberFormat) {
        return LocaleParser.parse(string, numberFormat, (Number)null);
    }

    @Nullable
    public static Number parse(@Nullable String string, @Nonnull NumberFormat numberFormat, @Nullable Number number) {
        ValueEnforcer.notNull(numberFormat, "NumberFormat");
        if (string != null) {
            try {
                return numberFormat.parse(string);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return number;
    }

    public static float parseFloat(@Nullable String string, @Nonnull Locale locale, float f) {
        return LocaleParser.parseFloat(string, NumberFormat.getInstance(locale), f);
    }

    public static float parseFloat(@Nullable String string, @Nonnull NumberFormat numberFormat, float f) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? f : number.floatValue();
    }

    public static double parseDouble(@Nullable String string, @Nonnull Locale locale, double d) {
        return LocaleParser.parseDouble(string, NumberFormat.getInstance(locale), d);
    }

    public static double parseDouble(@Nullable String string, @Nonnull NumberFormat numberFormat, double d) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? d : number.doubleValue();
    }

    public static byte parseByte(@Nullable String string, @Nonnull Locale locale, byte by) {
        return LocaleParser.parseByte(string, NumberFormat.getIntegerInstance(locale), by);
    }

    public static byte parseByte(@Nullable String string, @Nonnull NumberFormat numberFormat, byte by) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? by : number.byteValue();
    }

    public static int parseInt(@Nullable String string, @Nonnull Locale locale, int n) {
        return LocaleParser.parseInt(string, NumberFormat.getIntegerInstance(locale), n);
    }

    public static int parseInt(@Nullable String string, @Nonnull NumberFormat numberFormat, int n) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? n : number.intValue();
    }

    public static long parseLong(@Nullable String string, @Nonnull Locale locale, long l) {
        return LocaleParser.parseLong(string, NumberFormat.getIntegerInstance(locale), l);
    }

    public static long parseLong(@Nullable String string, @Nonnull NumberFormat numberFormat, long l) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? l : number.longValue();
    }

    public static short parseShort(@Nullable String string, @Nonnull Locale locale, short s) {
        return LocaleParser.parseShort(string, NumberFormat.getIntegerInstance(locale), s);
    }

    public static short parseShort(@Nullable String string, @Nonnull NumberFormat numberFormat, short s) {
        Number number = LocaleParser.parse(string, numberFormat);
        return number == null ? s : number.shortValue();
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull Locale locale) {
        return LocaleParser.parseBigDecimal(string, locale, (BigDecimal)null);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull Locale locale, @Nullable BigDecimal bigDecimal) {
        return LocaleParser.parseBigDecimal(string, NumberFormat.getInstance(locale), bigDecimal);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull DecimalFormat decimalFormat) {
        return LocaleParser.parseBigDecimal(string, decimalFormat, (BigDecimal)null);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull DecimalFormat decimalFormat, @Nullable BigDecimal bigDecimal) {
        ValueEnforcer.notNull(decimalFormat, "NumberFormat");
        decimalFormat.setParseBigDecimal(true);
        return (BigDecimal)LocaleParser.parse(string, decimalFormat, (Number)bigDecimal);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull NumberFormat numberFormat) {
        return LocaleParser.parseBigDecimal(string, numberFormat, (BigDecimal)null);
    }

    @Nullable
    public static BigDecimal parseBigDecimal(@Nullable String string, @Nonnull NumberFormat numberFormat, @Nullable BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = null;
        if (numberFormat instanceof DecimalFormat) {
            bigDecimal2 = LocaleParser.parseBigDecimal(string, (DecimalFormat)numberFormat);
        } else {
            Number number = LocaleParser.parse(string, numberFormat);
            if (number != null) {
                bigDecimal2 = BigDecimal.valueOf(number.doubleValue());
            }
        }
        return bigDecimal2 == null ? bigDecimal : bigDecimal2;
    }
}

