/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.io.IHasInputStreamAndReader;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.string.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public interface IHasByteArray
extends IHasSize,
IHasInputStreamAndReader {
    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public boolean isNotEmpty() {
        return this.size() > 0;
    }

    public boolean isCopy();

    @Nonnull
    @ReturnsMutableCopy
    default public byte[] getAllBytes() {
        return ArrayHelper.getCopy(this.bytes(), this.getOffset(), this.size());
    }

    @Nonnull
    @ReturnsMutableObject
    public byte[] bytes();

    default public boolean isPartialArray() {
        return this.hasOffset() || this.bytes().length != this.size();
    }

    @Nonnegative
    public int getOffset();

    default public boolean hasOffset() {
        return this.getOffset() > 0;
    }

    @Override
    @Nonnull
    default public InputStream getInputStream() {
        return new NonBlockingByteArrayInputStream(this.bytes(), this.getOffset(), this.size());
    }

    @Override
    default public boolean isReadMultiple() {
        return true;
    }

    default public void writeTo(@Nonnull @WillNotClose OutputStream outputStream) throws IOException {
        ValueEnforcer.notNull(outputStream, "OutputStream");
        outputStream.write(this.bytes(), this.getOffset(), this.size());
    }

    default public boolean startsWith(@Nonnull byte[] byArray) {
        return ArrayHelper.startsWith(this.bytes(), this.getOffset(), this.size(), byArray, 0, byArray.length);
    }

    @Nonnull
    default public String getHexEncoded() {
        return StringHelper.getHexEncoded(this.bytes(), this.getOffset(), this.size());
    }

    @Nonnull
    default public String getBytesAsString(@Nonnull Charset charset) {
        return new String(this.bytes(), this.getOffset(), this.size(), charset);
    }
}

