/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.resourcebundle;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.charset.CharsetHelper;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;

final class Utf8PropertyResourceBundle
extends ResourceBundle {
    private final PropertyResourceBundle m_aBundle;

    Utf8PropertyResourceBundle(@Nonnull PropertyResourceBundle propertyResourceBundle) {
        this.m_aBundle = ValueEnforcer.notNull(propertyResourceBundle, "Bundle");
    }

    @Nonnull
    public PropertyResourceBundle getBundle() {
        return this.m_aBundle;
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.m_aBundle.getKeys();
    }

    @Override
    protected Object handleGetObject(String string) {
        String string2 = this.m_aBundle.getString(string);
        return CharsetHelper.getAsStringInOtherCharset(string2, StandardCharsets.ISO_8859_1, StandardCharsets.UTF_8);
    }
}

