/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.streamprovider;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.IHasInputStreamAndReader;
import com.helger.commons.io.IHasReader;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.io.stream.StringInputStream;
import com.helger.commons.serialize.convert.SerializationConverter;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.Charset;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class StringInputStreamProvider
implements IHasInputStreamAndReader,
IHasReader {
    private String m_sData;
    private Charset m_aCharset;

    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnull Charset charset) {
        this(new String(cArray), charset);
    }

    public StringInputStreamProvider(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Charset charset) {
        this(new String(cArray, n, n2), charset);
    }

    public StringInputStreamProvider(@Nonnull CharSequence charSequence, @Nonnull Charset charset) {
        this(charSequence.toString(), charset);
    }

    public StringInputStreamProvider(@Nonnull String string, @Nonnull Charset charset) {
        this.m_sData = ValueEnforcer.notNull(string, "Data");
        this.m_aCharset = ValueEnforcer.notNull(charset, "Charset");
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        StreamHelper.writeSafeUTF(objectOutputStream, this.m_sData);
        SerializationConverter.writeConvertedObject(this.m_aCharset, objectOutputStream);
    }

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException {
        this.m_sData = StreamHelper.readSafeUTF(objectInputStream);
        this.m_aCharset = SerializationConverter.readConvertedObject(objectInputStream, Charset.class);
    }

    @Nonnull
    public final String getData() {
        return this.m_sData;
    }

    @Nonnull
    public final Charset getCharset() {
        return this.m_aCharset;
    }

    @Override
    @Nonnull
    public final StringInputStream getInputStream() {
        return new StringInputStream(this.m_sData, this.m_aCharset);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader(@Nonnull Charset charset) {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    @Nonnull
    public final NonBlockingStringReader getReader() {
        return new NonBlockingStringReader(this.m_sData);
    }

    @Override
    public final boolean isReadMultiple() {
        return true;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringInputStreamProvider stringInputStreamProvider = (StringInputStreamProvider)object;
        return this.m_sData.equals(stringInputStreamProvider.m_sData) && this.m_aCharset.equals(stringInputStreamProvider.m_aCharset);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sData).append(this.m_aCharset).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("data", this.m_sData).append("charset", this.m_aCharset).getToString();
    }
}

