/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.as2lib.util.dump.IHTTPOutgoingDumper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.http.EHttpMethod;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.CountingInputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.mail.cte.EContentTransferEncoding;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultSchemePortResolver;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2HttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2HttpClient.class);
    private final ClassicRequestBuilder m_aRequestBuilder;
    private final CloseableHttpClient m_aCloseableHttpClient;
    private CloseableHttpResponse m_aCloseableHttpResponse;

    @Nullable
    private static HttpHost _getProxyHost(@Nonnull Proxy proxy) {
        try {
            SocketAddress socketAddress = proxy.address();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
                InetAddress inetAddress = inetSocketAddress.getAddress();
                if (inetAddress != null) {
                    return new HttpHost(inetAddress, inetSocketAddress.getPort());
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No address in proxy:" + String.valueOf(proxy.address()) + "-" + (null != proxy.type() ? proxy.type().name() : "null"));
                }
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.error("Exception while setting proxy. Continue without proxy. Proxy: " + String.valueOf(proxy.address()) + "-" + (null != proxy.type() ? proxy.type().name() : "null"), (Throwable)runtimeException);
        }
        return null;
    }

    public AS2HttpClient(@Nonnull @Nonempty String string, @Nonnull Timeout timeout, @Nonnull Timeout timeout2, @Nonnull EHttpMethod eHttpMethod, @Nullable Proxy proxy, @Nullable SSLContext sSLContext, @Nullable HostnameVerifier hostnameVerifier) {
        HttpHost httpHost;
        DefaultClientTlsStrategy defaultClientTlsStrategy;
        ConnectionConfig.Builder builder = ConnectionConfig.custom().setConnectTimeout(timeout);
        PoolingHttpClientConnectionManagerBuilder poolingHttpClientConnectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(builder.build());
        if (sSLContext != null) {
            defaultClientTlsStrategy = new DefaultClientTlsStrategy(sSLContext, hostnameVerifier);
            poolingHttpClientConnectionManagerBuilder.setTlsSocketStrategy((TlsSocketStrategy)defaultClientTlsStrategy);
        }
        defaultClientTlsStrategy = null;
        if (proxy != null && (httpHost = AS2HttpClient._getProxyHost(proxy)) != null) {
            defaultClientTlsStrategy = new DefaultProxyRoutePlanner(httpHost, (SchemePortResolver)DefaultSchemePortResolver.INSTANCE);
        }
        httpHost = RequestConfig.custom().setCookieSpec("strict").setResponseTimeout(timeout2).setCircularRedirectsAllowed(false);
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setDefaultRequestConfig(httpHost.build()).setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManagerBuilder.build()).setRoutePlanner((HttpRoutePlanner)defaultClientTlsStrategy);
        this.m_aCloseableHttpClient = httpClientBuilder.build();
        this.m_aRequestBuilder = ClassicRequestBuilder.create((String)eHttpMethod.getName()).setUri(string);
    }

    public void setHttpHeader(@Nonnull String string, @Nonnull String string2) {
        ValueEnforcer.notNull((Object)string, (String)"Name");
        ValueEnforcer.notNull((Object)string2, (String)"Value");
        this.m_aRequestBuilder.setHeader(string, string2);
    }

    @Nonnull
    public URL getURL() throws AS2Exception {
        URI uRI = this.m_aRequestBuilder.getUri();
        try {
            return uRI.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            LOGGER.error("Failed to get URL from connection, URI: " + uRI.toASCIIString(), (Throwable)malformedURLException);
            throw new AS2Exception(malformedURLException.getCause());
        }
    }

    @Nonnegative
    public long send(@Nonnull @WillClose InputStream inputStream, final @Nullable EContentTransferEncoding eContentTransferEncoding, final @Nullable IHTTPOutgoingDumper iHTTPOutgoingDumper, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws IOException {
        try (final CountingInputStream countingInputStream = new CountingInputStream(inputStream);){
            AbstractHttpEntity abstractHttpEntity = new AbstractHttpEntity(null, eContentTransferEncoding != null ? eContentTransferEncoding.getID() : null){

                public void close() {
                }

                public InputStream getContent() throws IOException {
                    throw new UnsupportedOperationException();
                }

                public long getContentLength() {
                    return -1L;
                }

                public boolean isStreaming() {
                    return true;
                }

                public void writeTo(@Nonnull OutputStream outputStream) throws IOException {
                    try (OutputStream outputStream2 = iHTTPOutgoingDumper != null ? iHTTPOutgoingDumper.getDumpOS(outputStream) : outputStream;
                         OutputStream outputStream3 = eContentTransferEncoding != null ? AS2IOHelper.getContentTransferEncodingAwareOutputStream(outputStream2, eContentTransferEncoding.getID()) : outputStream2;){
                        StreamHelper.copyByteStream().from((InputStream)countingInputStream).closeFrom(true).to(outputStream3).closeTo(false).build();
                    }
                    catch (MessagingException messagingException) {
                        throw new IllegalStateException("Failed to encode OutputStream with CTE '" + String.valueOf(eContentTransferEncoding) + "'", messagingException);
                    }
                }
            };
            HttpEntity httpEntity = aS2ResourceHelper.createRepeatableHttpEntity((HttpEntity)abstractHttpEntity);
            this.m_aRequestBuilder.setEntity(httpEntity);
            ClassicHttpRequest classicHttpRequest = this.m_aRequestBuilder.build();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Performing HttpRequest to '" + classicHttpRequest.toString() + "'");
            }
            this.m_aCloseableHttpResponse = this.m_aCloseableHttpClient.execute(classicHttpRequest);
            long l = countingInputStream.getBytesRead();
            return l;
        }
    }

    public InputStream getInputStream() throws AS2Exception, IOException {
        if (this.m_aCloseableHttpResponse == null) {
            throw new AS2Exception("No response as message was yet sent");
        }
        return this.m_aCloseableHttpResponse.getEntity().getContent();
    }

    public int getResponseCode() throws AS2Exception {
        if (this.m_aCloseableHttpResponse == null) {
            throw new AS2Exception("No response as message was yet sent");
        }
        return this.m_aCloseableHttpResponse.getCode();
    }

    public String getResponseMessage() throws AS2Exception {
        if (this.m_aCloseableHttpResponse == null) {
            throw new AS2Exception("No response as message was yet sent");
        }
        return this.m_aCloseableHttpResponse.getReasonPhrase();
    }

    @Nonnull
    @ReturnsMutableCopy
    public HttpHeaderMap getResponseHeaderFields() throws AS2Exception {
        if (this.m_aCloseableHttpResponse == null) {
            throw new AS2Exception("No response as message was yet sent");
        }
        HttpHeaderMap httpHeaderMap = new HttpHeaderMap();
        Header[] headerArray = this.m_aCloseableHttpResponse.getHeaders();
        if (headerArray != null) {
            for (Header header : headerArray) {
                httpHeaderMap.addHeader(header.getName(), header.getValue());
            }
        }
        return httpHeaderMap;
    }

    public void disconnect() {
        try {
            if (this.m_aCloseableHttpResponse != null) {
                this.m_aCloseableHttpResponse.close();
            }
            if (this.m_aCloseableHttpClient != null) {
                this.m_aCloseableHttpClient.close();
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception while closing HttpClient connection: " + this.toString(), (Throwable)exception);
        }
    }

    public static boolean isErrorResponseCode(int n) {
        return n != 200 && n != 201 && n != 202 && n != 204 && n != 206;
    }
}

