/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.resender;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.processor.module.AbstractActiveModule;
import com.helger.as2lib.processor.resender.IProcessorResenderModule;
import com.helger.as2lib.session.IAS2Session;
import com.helger.commons.collection.attr.IStringMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractActiveResenderModule
extends AbstractActiveModule
implements IProcessorResenderModule {
    public static final String ATTR_RESEND_DELAY_SECONDS = "resenddelay";
    public static final String ATTR_POLLING_INTERVAL_SECONDS = "pollinginterval";
    public static final long DEFAULT_RESEND_DELAY_MS = 900000L;
    public static final long DEFAULT_POLLING_MS = 30000L;
    private Timer m_aTimer;
    private long m_nPollingMS = 30000L;

    @Override
    @OverridingMethodsMustInvokeSuper
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        super.initDynamicComponent(iAS2Session, iStringMap);
        if (this.attrs().containsKey((Object)ATTR_POLLING_INTERVAL_SECONDS)) {
            this.m_nPollingMS = this.attrs().getAsLong((Object)ATTR_POLLING_INTERVAL_SECONDS) * 1000L;
            if (this.m_nPollingMS < 1L) {
                throw new AS2Exception("The provided polling milliseconds value is invalid. It must be > 0 but is " + this.m_nPollingMS);
            }
        }
    }

    @Nonnegative
    protected final long getResendDelayMS() throws AS2InvalidParameterException {
        if (!this.attrs().containsKey((Object)ATTR_RESEND_DELAY_SECONDS)) {
            return 900000L;
        }
        return (long)this.getAttributeAsIntRequired(ATTR_RESEND_DELAY_SECONDS) * 1000L;
    }

    public abstract void resend();

    @Override
    @OverridingMethodsMustInvokeSuper
    public void doStart() throws AS2Exception {
        if (this.m_aTimer != null) {
            throw new IllegalStateException("Resending timer is already running!");
        }
        this.m_aTimer = new Timer("Resender", true);
        this.m_aTimer.scheduleAtFixedRate((TimerTask)new ResendPollTask(), 0L, this.m_nPollingMS);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void doStop() throws AS2Exception {
        if (this.m_aTimer != null) {
            this.m_aTimer.cancel();
            this.m_aTimer = null;
        }
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private class ResendPollTask
    extends TimerTask {
        private ResendPollTask() {
        }

        @Override
        public void run() {
            AbstractActiveResenderModule.this.resend();
        }
    }
}

