/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.disposition;

import com.helger.as2lib.disposition.AS2DispositionException;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DispositionType {
    public static final String ACTION_AUTOMATIC_ACTION = "automatic-action";
    public static final String MDNACTION_MDN_SENT_AUTOMATICALLY = "MDN-sent-automatically";
    public static final String STATUS_PROCESSED = "processed";
    public static final String STATUS_MODIFIER_ERROR = "Error";
    public static final String STATUS_MODIFIER_WARNING = "Warning";
    private final String m_sAction;
    private final String m_sMDNAction;
    private final String m_sStatus;
    private final String m_sStatusDescription;
    private final String m_sStatusModifier;

    public DispositionType(@Nonnull String string, @Nonnull String string2, @Nonnull String string3, @Nullable String string4, @Nullable String string5) {
        ValueEnforcer.notNull((Object)string, (String)"Action");
        ValueEnforcer.notNull((Object)string2, (String)"MDNAction");
        ValueEnforcer.notNull((Object)string3, (String)"Status");
        this.m_sAction = string;
        this.m_sMDNAction = string2;
        this.m_sStatus = string3;
        this.m_sStatusModifier = string4;
        this.m_sStatusDescription = string5;
    }

    @Nonnull
    public final String getAction() {
        return this.m_sAction;
    }

    @Nonnull
    public final String getMDNAction() {
        return this.m_sMDNAction;
    }

    @Nonnull
    public final String getStatus() {
        return this.m_sStatus;
    }

    @Nullable
    public final String getStatusDescription() {
        return this.m_sStatusDescription;
    }

    @Nullable
    public final String getStatusModifier() {
        return this.m_sStatusModifier;
    }

    public boolean isError() {
        return EqualsHelper.equalsIgnoreCase((String)this.m_sStatusModifier, (String)STATUS_MODIFIER_ERROR);
    }

    public boolean isWarning() {
        return EqualsHelper.equalsIgnoreCase((String)this.m_sStatusModifier, (String)STATUS_MODIFIER_WARNING);
    }

    public void validate(@Nonnull IMessage iMessage, @Nonnull String string) throws AS2DispositionException {
        if (this.isWarning()) {
            AS2DispositionException aS2DispositionException = new AS2DispositionException(this, string, null);
            AS2Exception.log(aS2DispositionException.getClass(), true, aS2DispositionException.getMessage(), null, iMessage, null);
        } else {
            if (!this.m_sStatus.equalsIgnoreCase(STATUS_PROCESSED)) {
                throw new AS2DispositionException(this, string, null);
            }
            if (this.isError()) {
                throw new AS2DispositionException(this, string, null);
            }
        }
    }

    @Nonnull
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.m_sAction).append('/').append(this.m_sMDNAction).append("; ").append(this.m_sStatus);
        if (this.m_sStatusModifier != null) {
            stringBuilder.append('/').append(this.m_sStatusModifier).append(':');
            if (StringHelper.hasText((String)this.m_sStatusDescription)) {
                stringBuilder.append(' ').append(this.m_sStatusDescription);
            }
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Action", (Object)this.m_sAction).append("MDNAction", (Object)this.m_sMDNAction).append("Status", (Object)this.m_sStatus).append("StatusModifier", (Object)this.m_sStatusModifier).append("StatusDescription", (Object)this.m_sStatusDescription).getToString();
    }

    @Nonnull
    public static DispositionType createFromString(@Nullable String string) throws AS2Exception {
        if (StringHelper.hasNoText((String)string)) {
            throw new AS2Exception("Disposition type is empty");
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/;:", false);
            String string2 = stringTokenizer.nextToken().toLowerCase(Locale.US);
            String string3 = stringTokenizer.nextToken().toLowerCase(Locale.US);
            String string4 = stringTokenizer.nextToken().trim().toLowerCase(Locale.US);
            String string5 = null;
            String string6 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken().trim().toLowerCase(Locale.US);
                if (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken().trim().toLowerCase(Locale.US);
                }
            }
            return new DispositionType(string2, string3, string4, string5, string6);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new AS2Exception("Invalid disposition type format '" + string + "'", noSuchElementException);
        }
    }

    @Nonnull
    public static DispositionType createSuccess() {
        return new DispositionType(ACTION_AUTOMATIC_ACTION, MDNACTION_MDN_SENT_AUTOMATICALLY, STATUS_PROCESSED, null, null);
    }

    @Nonnull
    public static DispositionType createError(@Nonnull String string) {
        return new DispositionType(ACTION_AUTOMATIC_ACTION, MDNACTION_MDN_SENT_AUTOMATICALLY, STATUS_PROCESSED, STATUS_MODIFIER_ERROR, string);
    }
}

