/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util;

import com.helger.commons.datetime.DateTimeFormatterCache;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.datetime.PDTFromString;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class AS2DateHelper {
    private AS2DateHelper() {
    }

    @Nonnull
    public static String getFormattedDateNow(@Nonnull String string) {
        return AS2DateHelper.formatDate(string, PDTFactory.getCurrentZonedDateTime());
    }

    @Nonnull
    public static String formatDate(@Nonnull String string, @Nonnull ZonedDateTime zonedDateTime) {
        try {
            return DateTimeFormatterCache.getDateTimeFormatterSmart((String)string).format(zonedDateTime);
        }
        catch (DateTimeException dateTimeException) {
            throw new IllegalArgumentException("Failed to format date '" + zonedDateTime + "' using format '" + string + "'", dateTimeException);
        }
    }

    @Nonnull
    public static LocalDateTime parseDate(@Nonnull String string, @Nonnull String string2) {
        ZonedDateTime zonedDateTime = PDTFromString.getZonedDateTimeFromString((String)string2, (String)string);
        if (zonedDateTime == null) {
            throw new IllegalArgumentException("Failed to parse date '" + string2 + "' using format '" + string + "'");
        }
        return zonedDateTime.toLocalDateTime();
    }
}

