/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.params;

import com.helger.as2lib.message.IMessageMDN;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.AbstractParameterParser;
import com.helger.as2lib.params.MessageParameters;
import com.helger.commons.ValueEnforcer;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageMDNParameters
extends AbstractParameterParser {
    public static final String KEY_MESSAGE = "msg";
    public static final String KEY_SENDER = "sender";
    public static final String KEY_RECEIVER = "receiver";
    public static final String KEY_TEXT = "text";
    public static final String KEY_ATTRIBUTES = "attributes";
    public static final String KEY_HEADERS = "headers";
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageMDNParameters.class);
    private final IMessageMDN m_aMDN;

    public MessageMDNParameters(@Nonnull IMessageMDN iMessageMDN) {
        this.m_aMDN = (IMessageMDN)ValueEnforcer.notNull((Object)iMessageMDN, (String)"Target");
    }

    @Override
    public void setParameter(String string, String string2) throws AS2InvalidParameterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.countTokens() < 2) {
            throw new AS2InvalidParameterException("Invalid key format", this, "key", string);
        }
        String string3 = stringTokenizer.nextToken();
        if (string3.equals(KEY_MESSAGE)) {
            if (stringTokenizer.countTokens() < 3) {
                throw new AS2InvalidParameterException("Invalid key format", this, "key", string);
            }
            String string4 = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
            new MessageParameters(this.m_aMDN.getMessage()).setParameter(string4, string2);
        } else {
            String string5 = stringTokenizer.nextToken();
            if (string3.equals(KEY_TEXT)) {
                this.m_aMDN.setText(string2);
            } else if (string3.equals(KEY_ATTRIBUTES)) {
                this.m_aMDN.attrs().putIn((Object)string5, (Object)string2);
            } else if (string3.equals(KEY_HEADERS)) {
                this.m_aMDN.headers().setHeader(string5, string2);
            } else {
                throw new AS2InvalidParameterException("Invalid area in key", this, "key", string);
            }
        }
    }

    @Override
    @Nullable
    public String getParameter(String string) throws AS2InvalidParameterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.countTokens() > 2) {
            String string2 = stringTokenizer.nextToken();
            if (!KEY_MESSAGE.equals(string2)) {
                LOGGER.warn("Skipping the token '" + string2 + "' and accessing the message parameters instead of the MDN property. Please use `msg` as the name of the skipped token to indicate that this is done by purpose.");
            }
            String string3 = stringTokenizer.nextToken() + "." + stringTokenizer.nextToken();
            return new MessageParameters(this.m_aMDN.getMessage()).getParameter(string3);
        }
        if (stringTokenizer.countTokens() < 2) {
            throw new AS2InvalidParameterException("Invalid key format", this, "key", string);
        }
        String string4 = stringTokenizer.nextToken();
        String string5 = stringTokenizer.nextToken();
        if (string4.equals(KEY_SENDER)) {
            return this.m_aMDN.partnership().getSenderID(string5);
        }
        if (string4.equals(KEY_RECEIVER)) {
            return this.m_aMDN.partnership().getReceiverID(string5);
        }
        if (string4.equals(KEY_TEXT)) {
            return this.m_aMDN.getText();
        }
        if (string4.equals(KEY_ATTRIBUTES)) {
            return this.m_aMDN.attrs().getAsString((Object)string5);
        }
        if (string4.equals(KEY_HEADERS)) {
            return this.m_aMDN.getHeader(string5);
        }
        throw new AS2InvalidParameterException("Invalid area in key", this, "key", string);
    }
}

