/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.message;

import com.helger.as2lib.message.AS2Message;
import com.helger.as2lib.message.AbstractMessageMDN;
import com.helger.as2lib.partner.Partnership;
import com.helger.as2lib.util.AS2DateHelper;
import com.helger.commons.string.StringHelper;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;

public class AS2MessageMDN
extends AbstractMessageMDN {
    public static final String MDNA_REPORTING_UA = "REPORTING_UA";
    public static final String MDNA_ORIG_RECIPIENT = "ORIGINAL_RECIPIENT";
    public static final String MDNA_FINAL_RECIPIENT = "FINAL_RECIPIENT";
    public static final String MDNA_ORIG_MESSAGEID = "ORIGINAL_MESSAGE_ID";
    public static final String MDNA_DISPOSITION = "DISPOSITION";
    public static final String MDNA_MIC = "MIC";
    public static final String DEFAULT_DATE_FORMAT = "ddMMuuuuHHmmssZ";

    public AS2MessageMDN(@Nonnull AS2Message aS2Message) {
        super(aS2Message);
        this.headers().setHeader("AS2-To", aS2Message.getAS2From());
        this.headers().setHeader("AS2-From", aS2Message.getAS2To());
    }

    @Override
    public String generateMessageID() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.partnership().getDateFormat(DEFAULT_DATE_FORMAT);
        stringBuilder.append('<').append("as2-lib").append('-').append(AS2DateHelper.getFormattedDateNow(string));
        int n = ThreadLocalRandom.current().nextInt(10000);
        stringBuilder.append('-').append(StringHelper.getLeadingZero((int)n, (int)4));
        Partnership partnership = this.getMessage().partnership();
        String string2 = partnership.getReceiverAS2ID();
        String string3 = partnership.getSenderAS2ID();
        stringBuilder.append('@').append(string2).append('_').append(string3);
        return stringBuilder.append('>').toString();
    }
}

