/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.client;

import com.helger.as2lib.crypto.ECompressionType;
import com.helger.as2lib.crypto.ECryptoAlgorithmCrypt;
import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.crypto.IMICMatchingHandler;
import com.helger.as2lib.disposition.DispositionOptions;
import com.helger.as2lib.processor.sender.AbstractHttpSenderModule;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.dump.IHTTPOutgoingDumperFactory;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.StringHelper;
import com.helger.security.keystore.EKeyStoreType;
import com.helger.security.keystore.IKeyStoreType;
import java.io.File;
import java.security.cert.X509Certificate;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hc.core5.util.Timeout;

public class AS2ClientSettings {
    public static final boolean DEFAULT_COMPRESS_BEFORE_SIGNING = true;
    public static final boolean DEFAULT_IS_MDN_REQUESTED = true;
    public static final String DEFAULT_MDN_OPTIONS = new DispositionOptions().setProtocolImportance("optional").setProtocol("pkcs7-signature").setMICAlgImportance("optional").setMICAlg(ECryptoAlgorithmSign.DIGEST_SHA_1).getAsString();
    public static final String DEFAULT_MESSAGE_ID_FORMAT = "as2-lib-$date.ddMMuuuuHHmmssZ$-$rand.1234$@$msg.sender.as2_id$_$msg.receiver.as2_id$";
    public static final int DEFAULT_RETRY_COUNT = 0;
    public static final Timeout DEFAULT_CONNECT_TIMEOUT = AbstractHttpSenderModule.DEFAULT_CONNECT_TIMEOUT;
    public static final Timeout DEFAULT_RESPONSE_TIMEOUT = AbstractHttpSenderModule.DEFAULT_RESPONSE_TIMEOUT;
    public static final boolean DEFAULT_QUOTE_HEADER_VALUES = false;
    private IKeyStoreType m_aKeyStoreType = EKeyStoreType.PKCS12;
    private File m_aKeyStoreFile;
    private byte[] m_aKeyStoreBytes;
    private String m_sKeyStorePassword;
    private boolean m_bSaveKeyStoreChangesToFile = true;
    private String m_sSenderEmailAddress;
    private String m_sSenderAS2ID;
    private String m_sSenderKeyAlias;
    private String m_sReceiverAS2ID;
    private String m_sReceiverKeyAlias;
    private String m_sDestinationAS2URL;
    private X509Certificate m_aReceiverCert;
    private String m_sPartnershipName;
    private ECryptoAlgorithmCrypt m_eCryptAlgo;
    private ECryptoAlgorithmSign m_eSignAlgo;
    private ECompressionType m_eCompressionType;
    private boolean m_bCompressBeforeSigning = true;
    private boolean m_bMDNRequested = true;
    private String m_sMDNOptions = DEFAULT_MDN_OPTIONS;
    private String m_sAsyncMDNUrl;
    private String m_sMessageIDFormat = "as2-lib-$date.ddMMuuuuHHmmssZ$-$rand.1234$@$msg.sender.as2_id$_$msg.receiver.as2_id$";
    private int m_nRetryCount = 0;
    private Timeout m_aConnectTimeout = DEFAULT_CONNECT_TIMEOUT;
    private Timeout m_aResponseTimeout = DEFAULT_RESPONSE_TIMEOUT;
    private boolean m_bQuoteHeaderValues = false;
    private final HttpHeaderMap m_aCustomHeaders = new HttpHeaderMap();
    private IHTTPOutgoingDumperFactory m_aHttpOutgoingDumperFactory;
    private IHTTPIncomingDumper m_aHttpIncomingDumper;
    private IMICMatchingHandler m_aMICMatchingHandler;
    private Consumer<? super X509Certificate> m_aVerificationCertificateConsumer;

    @Nonnull
    public final IKeyStoreType getKeyStoreType() {
        return this.m_aKeyStoreType;
    }

    @Nullable
    public final File getKeyStoreFile() {
        return this.m_aKeyStoreFile;
    }

    @Nullable
    public final byte[] getKeyStoreBytes() {
        return this.m_aKeyStoreBytes;
    }

    @Nullable
    public final String getKeyStorePassword() {
        return this.m_sKeyStorePassword;
    }

    @Nonnull
    public final AS2ClientSettings setKeyStore(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull File file, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"KeyStoreType");
        ValueEnforcer.notNull((Object)file, (String)"File");
        ValueEnforcer.notNull((Object)string, (String)"Password");
        this.m_aKeyStoreType = iKeyStoreType;
        this.m_aKeyStoreFile = file;
        this.m_aKeyStoreBytes = null;
        this.m_sKeyStorePassword = string;
        return this;
    }

    @Nonnull
    public final AS2ClientSettings setKeyStore(@Nonnull IKeyStoreType iKeyStoreType, @Nonnull byte[] byArray, @Nonnull String string) {
        ValueEnforcer.notNull((Object)iKeyStoreType, (String)"KeyStoreType");
        ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
        ValueEnforcer.notNull((Object)string, (String)"Password");
        this.m_aKeyStoreType = iKeyStoreType;
        this.m_aKeyStoreFile = null;
        this.m_aKeyStoreBytes = byArray;
        this.m_sKeyStorePassword = string;
        return this;
    }

    public final boolean isSaveKeyStoreChangesToFile() {
        return this.m_bSaveKeyStoreChangesToFile;
    }

    @Nonnull
    public final AS2ClientSettings setSaveKeyStoreChangesToFile(boolean bl) {
        this.m_bSaveKeyStoreChangesToFile = bl;
        return this;
    }

    @Nullable
    public final String getSenderAS2ID() {
        return this.m_sSenderAS2ID;
    }

    @Nullable
    public final String getSenderEmailAddress() {
        return this.m_sSenderEmailAddress;
    }

    @Nullable
    public final String getSenderKeyAlias() {
        return this.m_sSenderKeyAlias;
    }

    @Nonnull
    public final AS2ClientSettings setSenderData(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        this.m_sSenderAS2ID = (String)ValueEnforcer.notNull((Object)string, (String)"AS2ID");
        this.m_sSenderEmailAddress = (String)ValueEnforcer.notNull((Object)string2, (String)"EmailAddress");
        this.m_sSenderKeyAlias = (String)ValueEnforcer.notNull((Object)string3, (String)"KeyAlias");
        return this;
    }

    @Nullable
    public final String getReceiverAS2ID() {
        return this.m_sReceiverAS2ID;
    }

    @Nullable
    public final String getReceiverKeyAlias() {
        return this.m_sReceiverKeyAlias;
    }

    @Nullable
    public final String getDestinationAS2URL() {
        return this.m_sDestinationAS2URL;
    }

    @Nonnull
    public final AS2ClientSettings setReceiverData(@Nonnull String string, @Nonnull String string2, @Nonnull String string3) {
        this.m_sReceiverAS2ID = (String)ValueEnforcer.notNull((Object)string, (String)"AS2ID");
        this.m_sReceiverKeyAlias = (String)ValueEnforcer.notNull((Object)string2, (String)"KeyAlias");
        this.m_sDestinationAS2URL = (String)ValueEnforcer.notNull((Object)string3, (String)"AS2URL");
        return this;
    }

    @Nullable
    public final X509Certificate getReceiverCertificate() {
        return this.m_aReceiverCert;
    }

    @Nonnull
    public final AS2ClientSettings setReceiverCertificate(@Nullable X509Certificate x509Certificate) {
        this.m_aReceiverCert = x509Certificate;
        return this;
    }

    @Nullable
    public final ECryptoAlgorithmCrypt getCryptAlgo() {
        return this.m_eCryptAlgo;
    }

    @Nullable
    public final String getCryptAlgoID() {
        return this.m_eCryptAlgo == null ? null : this.m_eCryptAlgo.getID();
    }

    @Nullable
    public final ECryptoAlgorithmSign getSignAlgo() {
        return this.m_eSignAlgo;
    }

    @Nullable
    public final String getSignAlgoID() {
        return this.m_eSignAlgo == null ? null : this.m_eSignAlgo.getID();
    }

    @Nonnull
    public final AS2ClientSettings setEncryptAndSign(@Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt, @Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        this.m_eCryptAlgo = eCryptoAlgorithmCrypt;
        this.m_eSignAlgo = eCryptoAlgorithmSign;
        return this;
    }

    @Nullable
    public final ECompressionType getCompressionType() {
        return this.m_eCompressionType;
    }

    public final boolean isCompressBeforeSigning() {
        return this.m_bCompressBeforeSigning;
    }

    @Nonnull
    public final AS2ClientSettings setCompress(@Nullable ECompressionType eCompressionType, boolean bl) {
        this.m_eCompressionType = eCompressionType;
        this.m_bCompressBeforeSigning = bl;
        return this;
    }

    @Nullable
    public final String getPartnershipName() {
        return this.m_sPartnershipName;
    }

    @Nonnull
    public final AS2ClientSettings setPartnershipName(@Nonnull String string) {
        this.m_sPartnershipName = (String)ValueEnforcer.notNull((Object)string, (String)"PartnershipName");
        return this;
    }

    public final boolean isMDNRequested() {
        return this.m_bMDNRequested;
    }

    @Nonnull
    public final AS2ClientSettings setMDNRequested(boolean bl) {
        this.m_bMDNRequested = bl;
        return this;
    }

    @Nullable
    public final String getMDNOptions() {
        return this.m_sMDNOptions;
    }

    public final boolean hasMDNOptions() {
        return this.m_sMDNOptions != null;
    }

    @Nonnull
    public final AS2ClientSettings setMDNOptions(@Nullable String string) {
        this.m_sMDNOptions = string;
        return this;
    }

    @Nonnull
    public final AS2ClientSettings setMDNOptions(@Nonnull DispositionOptions dispositionOptions) {
        ValueEnforcer.notNull((Object)dispositionOptions, (String)"DispositionOptions");
        return this.setMDNOptions(dispositionOptions.getAsString());
    }

    @Nullable
    public final String getAsyncMDNUrl() {
        return this.m_sAsyncMDNUrl;
    }

    public final boolean isAsyncMDNRequested() {
        return StringHelper.hasText((String)this.m_sAsyncMDNUrl);
    }

    @Nonnull
    public final AS2ClientSettings setAsyncMDNUrl(@Nullable String string) {
        this.m_sAsyncMDNUrl = string;
        return this;
    }

    @Nonnull
    public final String getMessageIDFormat() {
        return this.m_sMessageIDFormat;
    }

    @Nonnull
    public final AS2ClientSettings setMessageIDFormat(@Nonnull String string) {
        this.m_sMessageIDFormat = (String)ValueEnforcer.notNull((Object)string, (String)"MessageIDFormat");
        return this;
    }

    public final int getRetryCount() {
        return this.m_nRetryCount;
    }

    @Nonnull
    public final AS2ClientSettings setRetryCount(int n) {
        this.m_nRetryCount = n;
        return this;
    }

    public final Timeout getConnectTimeout() {
        return this.m_aConnectTimeout;
    }

    @Nonnull
    public final AS2ClientSettings setConnectTimeout(@Nonnull Timeout timeout) {
        ValueEnforcer.notNull((Object)timeout, (String)"ConnectTimeout");
        this.m_aConnectTimeout = timeout;
        return this;
    }

    @Nonnull
    public final Timeout getResponseTimeout() {
        return this.m_aResponseTimeout;
    }

    @Nonnull
    public final AS2ClientSettings setResponseTimeout(@Nonnull Timeout timeout) {
        ValueEnforcer.notNull((Object)timeout, (String)"ResponseTimeout");
        this.m_aResponseTimeout = timeout;
        return this;
    }

    public final boolean isQuoteHeaderValues() {
        return this.m_bQuoteHeaderValues;
    }

    @Nonnull
    public final AS2ClientSettings setQuoteHeaderValues(boolean bl) {
        this.m_bQuoteHeaderValues = bl;
        return this;
    }

    @Nullable
    public final IHTTPOutgoingDumperFactory getHttpOutgoingDumperFactory() {
        return this.m_aHttpOutgoingDumperFactory;
    }

    @Nonnull
    public final AS2ClientSettings setHttpOutgoingDumperFactory(@Nullable IHTTPOutgoingDumperFactory iHTTPOutgoingDumperFactory) {
        this.m_aHttpOutgoingDumperFactory = iHTTPOutgoingDumperFactory;
        return this;
    }

    @Nullable
    public final IHTTPIncomingDumper getHttpIncomingDumper() {
        return this.m_aHttpIncomingDumper;
    }

    @Nonnull
    public final AS2ClientSettings setHttpIncomingDumper(@Nullable IHTTPIncomingDumper iHTTPIncomingDumper) {
        this.m_aHttpIncomingDumper = iHTTPIncomingDumper;
        return this;
    }

    @Nonnull
    @ReturnsMutableObject
    public final HttpHeaderMap customHeaders() {
        return this.m_aCustomHeaders;
    }

    @Nullable
    public final IMICMatchingHandler getMICMatchingHandler() {
        return this.m_aMICMatchingHandler;
    }

    @Nonnull
    public final AS2ClientSettings setMICMatchingHandler(@Nullable IMICMatchingHandler iMICMatchingHandler) {
        this.m_aMICMatchingHandler = iMICMatchingHandler;
        return this;
    }

    @Nullable
    public final Consumer<? super X509Certificate> getVerificationCertificateConsumer() {
        return this.m_aVerificationCertificateConsumer;
    }

    @Nonnull
    public final AS2ClientSettings setVerificationCertificateConsumer(@Nullable Consumer<? super X509Certificate> consumer) {
        this.m_aVerificationCertificateConsumer = consumer;
        return this;
    }
}

