/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.cert;

import com.helger.as2lib.cert.ICertificateFactory;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.commons.io.EAppend;
import com.helger.commons.io.file.FileHelper;
import com.helger.security.keystore.KeyStoreHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IStorableCertificateFactory
extends ICertificateFactory {
    public static final boolean DEFAULT_SAVE_CHANGES_TO_FILE = true;

    public void setFilename(@Nullable String var1);

    @Nullable
    public String getFilename();

    default public void setPassword(@Nonnull char[] cArray) {
        this.setPassword(new String(cArray));
    }

    public void setPassword(@Nullable String var1);

    @Nullable
    public char[] getPassword();

    public void setSaveChangesToFile(boolean var1);

    public boolean isSaveChangesToFile();

    default public void load() throws AS2Exception {
        this.load(this.getFilename(), this.getPassword());
    }

    default public void load(@Nonnull String string, @Nonnull char[] cArray) throws AS2Exception {
        InputStream inputStream = null;
        try {
            inputStream = KeyStoreHelper.getResourceProvider().getInputStream(string);
            if (inputStream == null) {
                throw new AS2Exception("Failed to to open input stream from '" + string + "'");
            }
        }
        catch (RuntimeException runtimeException) {
            throw new AS2Exception("Failed to to open input stream from '" + string + "'", runtimeException);
        }
        this.load(inputStream, cArray);
    }

    public void load(@Nonnull InputStream var1, @Nonnull char[] var2) throws AS2Exception;

    default public void save() throws AS2Exception {
        this.save(this.getFilename(), this.getPassword());
    }

    default public void save(@Nonnull String string, @Nonnull char[] cArray) throws AS2Exception {
        FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)new File(string), (EAppend)EAppend.TRUNCATE);
        if (fileOutputStream == null) {
            throw new AS2Exception("Failed to to open output stream to '" + string + "'");
        }
        this.save(fileOutputStream, cArray);
    }

    public void save(@Nonnull OutputStream var1, @Nonnull char[] var2) throws AS2Exception;
}

