/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.util.AS2Helper;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.dump.HTTPIncomingDumperDirectoryBased;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.as2lib.util.http.ChunkedInputStream;
import com.helger.as2lib.util.http.IAS2HttpRequestDataProvider;
import com.helger.as2lib.util.http.IAS2HttpResponseHandler;
import com.helger.as2lib.util.http.TempSharedFileInputStream;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.codec.IByteArrayCodec;
import com.helger.commons.codec.IdentityCodec;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.http.CHttp;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.IWriteToStream;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.commons.system.SystemProperties;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.mail.datasource.ByteArrayDataSource;
import com.helger.mail.datasource.IExtendedDataSource;
import com.helger.mail.datasource.InputStreamDataSource;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class HTTPHelper {
    public static final String MA_HTTP_REQ_TYPE = "HTTP_REQUEST_TYPE";
    public static final String MA_HTTP_REQ_URL = "HTTP_REQUEST_URL";
    public static final String MA_HTTP_REQ_VERSION = "HTTP_REQUEST_VERSION";
    public static final String MA_HTTP_ORIGINAL_CONTENT_TRANSFER_ENCODING = "HTTP_ORIGINAL_CONTENT_TRANSFER_ENCODING";
    public static final String MA_HTTP_ORIGINAL_CONTENT_LENGTH = "HTTP_ORIGINAL_CONTENT_LENGTH";
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPHelper.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static Supplier<? extends IHTTPIncomingDumper> s_aHTTPIncomingDumperFactory = () -> null;

    private HTTPHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<String> getAllHTTPHeaderLines(@Nonnull HttpHeaderMap httpHeaderMap) {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        httpHeaderMap.forEachHeaderLine(arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0), true);
        return commonsArrayList;
    }

    @Nullable
    public static IHTTPIncomingDumper getHTTPIncomingDumper() {
        return (IHTTPIncomingDumper)RW_LOCK.readLockedGet(() -> s_aHTTPIncomingDumperFactory.get());
    }

    @Nonnull
    public static Supplier<? extends IHTTPIncomingDumper> getHTTPIncomingDumperFactory() {
        return (Supplier)RW_LOCK.readLockedGet(() -> s_aHTTPIncomingDumperFactory);
    }

    public static void setHTTPIncomingDumperFactory(@Nonnull Supplier<? extends IHTTPIncomingDumper> supplier) {
        ValueEnforcer.notNull(supplier, (String)"HttpDumperFactory");
        RW_LOCK.writeLocked(() -> {
            s_aHTTPIncomingDumperFactory = supplier;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static IExtendedDataSource readHttpRequest(@Nonnull IAS2HttpRequestDataProvider iAS2HttpRequestDataProvider, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnull IMessage iMessage, @Nullable IHTTPIncomingDumper iHTTPIncomingDumper) throws IOException, MessagingException {
        ByteArrayDataSource byteArrayDataSource;
        byte[] byArray;
        iMessage.attrs().putIn((Object)MA_HTTP_REQ_TYPE, (Object)iAS2HttpRequestDataProvider.getHttpRequestMethod());
        iMessage.attrs().putIn((Object)MA_HTTP_REQ_URL, (Object)iAS2HttpRequestDataProvider.getHttpRequestUrl());
        iMessage.attrs().putIn((Object)MA_HTTP_REQ_VERSION, (Object)iAS2HttpRequestDataProvider.getHttpRequestVersion());
        InputStream inputStream = iAS2HttpRequestDataProvider.getHttpInputStream();
        iMessage.headers().setAllHeaders(iAS2HttpRequestDataProvider.getHttpHeaderMap());
        String string = AS2HttpHelper.getCleanContentType(iMessage.getHeader("Content-Type"));
        String string2 = iMessage.getHeader("Content-Length");
        if (string2 == null) {
            TempSharedFileInputStream tempSharedFileInputStream;
            boolean bl;
            String string3 = iMessage.getHeader("Transfer-Encoding");
            if (string3 == null) {
                HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 411);
                throw new IOException("Content-Length is missing and no Transfer-Encoding is specified");
            }
            if (!AS2Helper.getWithoutSpaces(string3).equalsIgnoreCase("chunked")) {
                HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 411);
                throw new IOException("Transfer-Encoding unimplemented: '" + string3 + "'");
            }
            boolean bl2 = bl = !iAS2HttpRequestDataProvider.isChunkedEncodingAlreadyProcessed();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Handling HTTP chunked Transfer-Encoding request " + (bl ? "in here as chunked encoding" : "as already processed"));
            }
            TempSharedFileInputStream tempSharedFileInputStream2 = tempSharedFileInputStream = TempSharedFileInputStream.getTempSharedFileInputStream((InputStream)(bl ? new ChunkedInputStream(inputStream) : inputStream), iMessage.getMessageID());
            iMessage.setTempSharedFileInputStream(tempSharedFileInputStream);
            byArray = null;
            byteArrayDataSource = new InputStreamDataSource((InputStream)((Object)tempSharedFileInputStream2), iMessage.getAS2From() == null ? "" : iMessage.getAS2From(), string, true);
        } else {
            long l = StringParser.parseLong((String)string2, (long)-1L);
            if (l < 0L || l > Integer.MAX_VALUE) {
                HTTPHelper.sendSimpleHTTPResponse(iAS2HttpResponseHandler, 411);
                throw new IOException("Content-Length '" + string2 + "' is invalid. Only values between 0 and 2147483647 are allowed.");
            }
            byArray = new byte[(int)l];
            try (DataInputStream dataInputStream = new DataInputStream(inputStream);){
                dataInputStream.readFully(byArray);
            }
            byteArrayDataSource = new ByteArrayDataSource(byArray, string, null);
        }
        if (iHTTPIncomingDumper != null) {
            iHTTPIncomingDumper.dumpIncomingRequest((List<String>)HTTPHelper.getAllHTTPHeaderLines(iAS2HttpRequestDataProvider.getHttpHeaderMap()), byArray != null ? byArray : "Payload body was not read yet, and therefore it cannot be dumped (yet) - sorry".getBytes(StandardCharsets.ISO_8859_1), iMessage);
        }
        return byteArrayDataSource;
    }

    @Nonnull
    public static DataSource readAndDecodeHttpRequest(@Nonnull IAS2HttpRequestDataProvider iAS2HttpRequestDataProvider, @Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnull IMessage iMessage, @Nullable IHTTPIncomingDumper iHTTPIncomingDumper) throws IOException, MessagingException {
        IExtendedDataSource iExtendedDataSource = HTTPHelper.readHttpRequest(iAS2HttpRequestDataProvider, iAS2HttpResponseHandler, iMessage, iHTTPIncomingDumper);
        String string = iMessage.partnership().getContentTransferEncodingReceive(EContentTransferEncoding.AS2_DEFAULT.getID());
        String string2 = iMessage.getHeaderOrDefault("Content-Transfer-Encoding", string);
        if (StringHelper.hasText((String)string2)) {
            EContentTransferEncoding eContentTransferEncoding = EContentTransferEncoding.getFromIDCaseInsensitiveOrNull((String)string2);
            if (eContentTransferEncoding == null) {
                LOGGER.warn("Unsupported Content-Transfer-Encoding '" + string2 + "' is used - ignoring!");
            } else {
                IByteArrayCodec iByteArrayCodec = eContentTransferEncoding.createCodec();
                if (!(iByteArrayCodec instanceof IdentityCodec) && iExtendedDataSource instanceof ByteArrayDataSource) {
                    byte[] byArray = ((ByteArrayDataSource)iExtendedDataSource).directGetBytes();
                    int n = byArray.length;
                    LOGGER.info("Incoming message uses Content-Transfer-Encoding '" + string2 + "' - decoding");
                    byArray = iByteArrayCodec.getDecoded(byArray);
                    iExtendedDataSource = new ByteArrayDataSource(byArray, iExtendedDataSource.getContentType(), iExtendedDataSource.getName());
                    iMessage.attrs().putIn((Object)MA_HTTP_ORIGINAL_CONTENT_TRANSFER_ENCODING, (Object)string2);
                    iMessage.attrs().putIn(MA_HTTP_ORIGINAL_CONTENT_LENGTH, n);
                }
            }
        }
        return iExtendedDataSource;
    }

    public static void sendSimpleHTTPResponse(@Nonnull IAS2HttpResponseHandler iAS2HttpResponseHandler, @Nonnegative int n) throws IOException {
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            String string = Integer.toString(n) + " " + CHttp.getHttpResponseMessage((int)n) + "\r\n";
            nonBlockingByteArrayOutputStream.write(string.getBytes(CHttp.HTTP_CHARSET));
            iAS2HttpResponseHandler.sendHttpResponse(n, new HttpHeaderMap(), (IWriteToStream)nonBlockingByteArrayOutputStream);
        }
    }

    @Nonnull
    private static String _debugByte(int n) {
        if (n >= 32 && n <= 126) {
            return "'" + Character.toString((char)n) + "'";
        }
        return "0x" + StringHelper.getHexStringLeadingZero((int)(n & 0xFF), (int)2);
    }

    @Nonnegative
    public static int readChunkLen(@Nonnull @WillNotClose InputStream inputStream) throws IOException {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(128);){
            while (true) {
                int n3;
                if ((n3 = inputStream.read()) < 0) {
                    if (n2 > 0) break;
                    throw new EOFException("EOF while reading HTTP chunk length");
                }
                ++n2;
                if (nonBlockingByteArrayOutputStream.size() < 128) {
                    nonBlockingByteArrayOutputStream.write(n3 & 0xFF);
                }
                if (n3 == 10) break;
                if (n3 >= 97 && n3 <= 102) {
                    n3 -= 87;
                } else if (n3 >= 65 && n3 <= 70) {
                    n3 -= 55;
                } else if (n3 >= 48 && n3 <= 57) {
                    n3 -= 48;
                } else if (n3 == 59) {
                    bl = true;
                } else {
                    if (n3 == 13 || bl || bl2) continue;
                    LOGGER.warn("Found unsupported byte " + HTTPHelper._debugByte(n3) + " when trying to read HTTP chunk length. This will most likely lead to an error processing the incoming AS2 message.");
                    bl2 = true;
                    continue;
                }
                if (bl) continue;
                n = n * 16 + n3;
            }
            if (bl2) {
                StringBuilder stringBuilder = new StringBuilder(nonBlockingByteArrayOutputStream.size() * 8);
                for (byte by : nonBlockingByteArrayOutputStream.toByteArray()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(HTTPHelper._debugByte(by));
                }
                boolean bl3 = n2 > nonBlockingByteArrayOutputStream.size();
                LOGGER.warn("An incoming AS2 message with HTTP Chunked Encoding had issues reading the 'chunk length'. A total of " + n2 + " bytes were read, the determined chunk length is " + n + ". Processing of the message might fail. " + (bl3 ? "Partial" : "Full") + " debug info: " + stringBuilder.toString());
            }
        }
        return n;
    }

    @Deprecated
    public static void readTillNexLine(@Nonnull @WillNotClose InputStream inputStream) throws IOException {
        HTTPHelper.readTillNextLine(inputStream);
    }

    public static void readTillNextLine(@Nonnull @WillNotClose InputStream inputStream) throws IOException {
        int n = 0;
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) < 0) {
                throw new EOFException("EOF while reading until next newline character");
            }
            if (n2 == 10) break;
            ++n;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Skipped " + n + " bytes until newline");
        }
    }

    static {
        String string = SystemProperties.getPropertyValueOrNull((String)"AS2.httpDumpDirectoryIncoming");
        if (StringHelper.hasNoText((String)string) && StringHelper.hasText((String)(string = SystemProperties.getPropertyValueOrNull((String)"AS2.httpDumpDirectory")))) {
            LOGGER.warn("You are using a legacy system property name `AS2.httpDumpDirectory`. Please use `AS2.httpDumpDirectoryIncoming` instead.");
        }
        if (StringHelper.hasText((String)string)) {
            File file = new File(string);
            AS2IOHelper.getFileOperationManager().createDirIfNotExisting(file);
            HTTPHelper.setHTTPIncomingDumperFactory(() -> new HTTPIncomingDumperDirectoryBased(file));
        }
    }
}

