/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.dump;

import com.helger.as2lib.message.IBaseMessage;
import com.helger.as2lib.util.dump.IHTTPIncomingDumper;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.http.CHttp;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPIncomingDumperDirectoryBased
implements IHTTPIncomingDumper {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPIncomingDumperDirectoryBased.class);
    private final File m_aDumpDirectory;

    public HTTPIncomingDumperDirectoryBased(@Nonnull File file) {
        ValueEnforcer.notNull((Object)file, (String)"DumpDirectory");
        ValueEnforcer.isTrue((boolean)FileHelper.existsDir((File)file), () -> "DumpDirectory " + file + " does not exist!");
        this.m_aDumpDirectory = file;
    }

    @Nonnull
    public File getDumpDirectory() {
        return this.m_aDumpDirectory;
    }

    @Nonnull
    protected String getStoreFilename(int n) {
        return "as2-incoming-" + Long.toString(System.currentTimeMillis()) + "-" + n + ".http";
    }

    protected void writeToFile(@Nonnull File file, @Nonnull List<String> list, @Nonnull byte[] byArray, @Nullable IBaseMessage iBaseMessage) {
        LOGGER.info("Dumping incoming HTTP request to file " + file.getAbsolutePath());
        try (FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);){
            for (String string : list) {
                ((OutputStream)fileOutputStream).write((string + "\r\n").getBytes(CHttp.HTTP_CHARSET));
            }
            ((OutputStream)fileOutputStream).write("\r\n".getBytes(CHttp.HTTP_CHARSET));
            ((OutputStream)fileOutputStream).write(byArray);
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to dump HTTP request to file " + file.getAbsolutePath() + " and message stub " + iBaseMessage, (Throwable)iOException);
        }
    }

    @Override
    public void dumpIncomingRequest(@Nonnull List<String> list, @Nonnull byte[] byArray, @Nullable IBaseMessage iBaseMessage) {
        File file;
        int n = 0;
        do {
            file = new File(this.m_aDumpDirectory, this.getStoreFilename(n));
            if (++n <= 100) continue;
            throw new IllegalStateException("Avoid endless loop to store message!");
        } while (file.exists());
        this.writeToFile(file, list, byArray, iBaseMessage);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("DumpDirectory", (Object)this.m_aDumpDirectory).getToString();
    }
}

