/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.params;

import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.AbstractParameterParser;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import jakarta.mail.internet.ContentDisposition;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MessageParameters
extends AbstractParameterParser {
    public static final String KEY_SENDER = "sender";
    public static final String KEY_RECEIVER = "receiver";
    public static final String KEY_ATTRIBUTES = "attributes";
    public static final String KEY_HEADERS = "headers";
    public static final String KEY_CONTENT_DISPOSITION = "content-disposition";
    public static final String ATTR_STORED_FILE_NAME = "storedfilename";
    private final IMessage m_aTarget;

    public MessageParameters(@Nonnull IMessage iMessage) {
        this.m_aTarget = (IMessage)ValueEnforcer.notNull((Object)iMessage, (String)"Target");
    }

    @Override
    public void setParameter(@Nonnull String string, @Nullable String string2) throws AS2InvalidParameterException {
        String[] stringArray = StringHelper.getExplodedArray((char)'.', (String)string, (int)2);
        if (stringArray.length != 2) {
            throw new AS2InvalidParameterException("Invalid key format", this, string, null);
        }
        String string3 = stringArray[0];
        String string4 = stringArray[1];
        if (string3.equals(KEY_SENDER)) {
            this.m_aTarget.partnership().setSenderID(string4, string2);
        } else if (string3.equals(KEY_RECEIVER)) {
            this.m_aTarget.partnership().setReceiverID(string4, string2);
        } else if (string3.equals(KEY_ATTRIBUTES)) {
            this.m_aTarget.attrs().putIn((Object)string4, (Object)string2);
        } else if (string3.equals(KEY_HEADERS)) {
            this.m_aTarget.headers().setHeader(string4, string2);
        } else {
            throw new AS2InvalidParameterException("Invalid area in key", this, string, null);
        }
    }

    @Nonnull
    @Nonempty
    private String _getContentDispositionFilename() {
        String string = "noContentDispositionFilename";
        String string2 = this.m_aTarget.getContentDisposition();
        if (StringHelper.hasText((String)string2)) {
            try {
                ContentDisposition contentDisposition = new ContentDisposition(string2);
                string = contentDisposition.getParameter("filename");
            }
            catch (Exception exception) {
                throw new IllegalStateException("Error parsing parameter", exception);
            }
        }
        return string;
    }

    @Override
    @Nullable
    public String getParameter(@Nonnull String string) throws AS2InvalidParameterException {
        String[] stringArray = StringHelper.getExplodedArray((char)'.', (String)string);
        if (stringArray.length != 2) {
            throw new AS2InvalidParameterException("Invalid key format", this, string, null);
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        if (string2.equals(KEY_SENDER)) {
            return this.m_aTarget.partnership().getSenderID(string3);
        }
        if (string2.equals(KEY_RECEIVER)) {
            return this.m_aTarget.partnership().getReceiverID(string3);
        }
        if (string2.equals(KEY_ATTRIBUTES)) {
            return this.m_aTarget.attrs().getAsString((Object)string3);
        }
        if (string2.equals(KEY_HEADERS)) {
            return this.m_aTarget.getHeader(string3);
        }
        if (string2.equals(KEY_CONTENT_DISPOSITION) && string3.equals("filename")) {
            return this._getContentDispositionFilename();
        }
        throw new AS2InvalidParameterException("Invalid area in key", this, string, null);
    }

    @Nullable
    public static String getEscapedString(@Nullable String string) {
        return StringHelper.replaceAll((String)string, (String)"$", (CharSequence)"$$");
    }
}

