/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.params;

import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.AbstractParameterParser;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.lang.ClassHelper;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeParameters
extends AbstractParameterParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeParameters.class);
    private ICommonsMap<String, AbstractParameterParser> m_aParameterParsers;
    private boolean m_bIgnoreMissingParsers;

    public CompositeParameters(boolean bl) {
        this.m_bIgnoreMissingParsers = bl;
    }

    public CompositeParameters(boolean bl, @Nonnull Map<String, ? extends AbstractParameterParser> map) {
        this(bl);
        this.getParameterParsers().putAll(map);
    }

    @Nonnull
    public CompositeParameters add(String string, AbstractParameterParser abstractParameterParser) {
        this.getParameterParsers().put((Object)string, (Object)abstractParameterParser);
        return this;
    }

    public void setIgnoreMissingParsers(boolean bl) {
        this.m_bIgnoreMissingParsers = bl;
    }

    public boolean isIgnoreMissingParsers() {
        return this.m_bIgnoreMissingParsers;
    }

    @Override
    public void setParameter(String string, String string2) throws AS2InvalidParameterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        AbstractParameterParser abstractParameterParser = (AbstractParameterParser)this.getParameterParsers().get((Object)stringTokenizer.nextToken());
        if (abstractParameterParser != null) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new AS2InvalidParameterException("Invalid key format", this, string, null);
            }
            StringBuilder stringBuilder = new StringBuilder(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append('.').append(stringTokenizer.nextToken());
            }
            abstractParameterParser.setParameter(stringBuilder.toString(), string2);
        } else if (!this.isIgnoreMissingParsers()) {
            throw new AS2InvalidParameterException("Invalid area in key", this, string, string2);
        }
    }

    @Override
    public String getParameter(String string) throws AS2InvalidParameterException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        String string2 = stringTokenizer.nextToken();
        AbstractParameterParser abstractParameterParser = (AbstractParameterParser)this.getParameterParsers().get((Object)string2);
        if (abstractParameterParser != null) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new AS2InvalidParameterException("Invalid key format", this, string, null);
            }
            StringBuilder stringBuilder = new StringBuilder(stringTokenizer.nextToken());
            while (stringTokenizer.hasMoreTokens()) {
                stringBuilder.append('.').append(stringTokenizer.nextToken());
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Nested getParameter: " + ClassHelper.getClassLocalName((Object)abstractParameterParser) + " with '" + stringBuilder.toString() + "'");
            }
            return abstractParameterParser.getParameter(stringBuilder.toString());
        }
        if (!this.isIgnoreMissingParsers()) {
            throw new AS2InvalidParameterException("Invalid area in key", this, string, null);
        }
        return "";
    }

    public void setParameterParsers(@Nullable ICommonsMap<String, AbstractParameterParser> iCommonsMap) {
        this.m_aParameterParsers = iCommonsMap;
    }

    @Nonnull
    @ReturnsMutableObject(value="by design")
    protected final ICommonsMap<String, AbstractParameterParser> getParameterParsers() {
        if (this.m_aParameterParsers == null) {
            this.m_aParameterParsers = new CommonsHashMap();
        }
        return this.m_aParameterParsers;
    }
}

