/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.message;

import com.helger.as2lib.message.AbstractBaseMessage;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.message.IMessageMDN;
import com.helger.as2lib.util.http.TempSharedFileInputStream;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.string.ToStringGenerator;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessage
extends AbstractBaseMessage
implements IMessage {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMessage.class);
    private MimeBodyPart m_aData;
    private IMessageMDN m_aMDN;
    private TempSharedFileInputStream m_aTempSharedFileInputStream;

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        try {
            if (objectInputStream.read() == 1) {
                this.m_aData = new MimeBodyPart((InputStream)objectInputStream);
            }
        }
        catch (MessagingException messagingException) {
            throw new IOException("Messaging exception", messagingException);
        }
        this.m_aMDN = (IMessageMDN)objectInputStream.readObject();
        if (this.m_aMDN != null) {
            this.m_aMDN.setMessage(this);
        }
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();){
            try {
                if (this.m_aData != null) {
                    nonBlockingByteArrayOutputStream.write(1);
                    this.m_aData.writeTo((OutputStream)nonBlockingByteArrayOutputStream);
                } else {
                    nonBlockingByteArrayOutputStream.write(0);
                }
            }
            catch (MessagingException messagingException) {
                throw new IOException("Messaging exception: " + messagingException.getMessage());
            }
            objectOutputStream.write(nonBlockingByteArrayOutputStream.toByteArray());
        }
        objectOutputStream.writeObject(this.m_aMDN);
    }

    @Override
    @Nullable
    public final MimeBodyPart getData() {
        return this.m_aData;
    }

    @Override
    public final void setData(@Nullable MimeBodyPart mimeBodyPart) {
        this.m_aData = mimeBodyPart;
        if (mimeBodyPart != null) {
            try {
                this.setContentType(mimeBodyPart.getContentType());
            }
            catch (MessagingException messagingException) {
                LOGGER.warn("Failed to set the Content-Type from the MimeBodyPart. Defaulting to null.");
                this.setContentType(null);
            }
            try {
                this.setContentDisposition(mimeBodyPart.getHeader("Content-Disposition", null));
            }
            catch (MessagingException messagingException) {
                LOGGER.warn("Failed to set the Content-Disposition from the MimeBodyPart. Defaulting to null.");
                this.setContentDisposition(null);
            }
        }
    }

    @Override
    @Nullable
    public final IMessageMDN getMDN() {
        return this.m_aMDN;
    }

    @Override
    public final void setMDN(@Nullable IMessageMDN iMessageMDN) {
        this.m_aMDN = iMessageMDN;
    }

    @Override
    @Nullable
    public final TempSharedFileInputStream getTempSharedFileInputStream() {
        return this.m_aTempSharedFileInputStream;
    }

    @Override
    public final void setTempSharedFileInputStream(@Nullable TempSharedFileInputStream tempSharedFileInputStream) {
        this.m_aTempSharedFileInputStream = tempSharedFileInputStream;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Message From:").append(this.partnership().getAllSenderIDs());
        stringBuilder.append('\n').append("To:").append(this.partnership().getAllReceiverIDs());
        stringBuilder.append('\n').append("Headers:").append(this.headers().toString());
        stringBuilder.append('\n').append("Attributes:").append(this.attrs().toString());
        IMessageMDN iMessageMDN = this.getMDN();
        if (iMessageMDN != null) {
            stringBuilder.append('\n').append("MDN:").append(iMessageMDN.getAsString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return new ToStringGenerator((Object)this).append("data", (Object)this.m_aData).append("MDN", (Object)this.m_aMDN).getToString();
    }
}

