/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.exception;

import com.helger.as2lib.CAS2Info;
import com.helger.as2lib.message.IMessage;
import com.helger.commons.lang.ClassHelper;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AS2Exception
extends Exception {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2Exception.class);
    private transient IMessage m_aSrcMsg;

    public AS2Exception(@Nullable String string) {
        super(string);
    }

    public AS2Exception(@Nullable String string, @Nullable Throwable throwable) {
        super(string, throwable);
    }

    public AS2Exception(@Nullable Throwable throwable) {
        super(throwable);
    }

    @Nullable
    public final IMessage getSourceMsg() {
        return this.m_aSrcMsg;
    }

    @Nonnull
    public final AS2Exception setSourceMsg(@Nullable IMessage iMessage) {
        this.m_aSrcMsg = iMessage;
        return this;
    }

    public static final void log(Class<?> clazz, boolean bl, String string, @Nullable File file, @Nullable IMessage iMessage, @Nullable Throwable throwable) {
        LOGGER.info(CAS2Info.NAME_VERSION + " " + ClassHelper.getClassLocalName(clazz) + " " + (bl ? "terminated" : "caught") + ": " + string + (String)(file == null ? "" : "; source file: " + file.getAbsolutePath()) + (String)(iMessage == null ? "" : "; source msg: " + iMessage.getLoggingText()), throwable);
    }

    protected final void log(boolean bl, @Nullable File file, @Nullable IMessage iMessage) {
        AS2Exception.log(this.getClass(), bl, this.getMessage(), file, iMessage, this.getCause());
    }

    @Nonnull
    public final AS2Exception terminate() {
        this.log(true, null, this.m_aSrcMsg);
        return this;
    }

    public final void terminate(@Nullable IMessage iMessage) {
        this.log(true, null, iMessage);
    }

    public final void terminate(@Nullable File file, @Nullable IMessage iMessage) {
        this.log(true, file, iMessage);
    }
}

