/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.crypto;

import com.helger.as2lib.crypto.ECryptoAlgorithmCrypt;
import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.as2lib.crypto.ICryptoHelper;
import com.helger.as2lib.crypto.MIC;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.util.AS2HttpHelper;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.as2lib.util.AS2ResourceHelper;
import com.helger.bc.PBCProvider;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.NullOutputStream;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.priviledged.AccessControllerHelper;
import com.helger.commons.string.StringHelper;
import com.helger.commons.system.SystemProperties;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.security.keystore.IKeyStoreType;
import jakarta.activation.CommandMap;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillNotClose;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.Recipient;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientId;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import org.bouncycastle.mail.smime.SMIMEEnvelopedParser;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.mail.smime.SMIMESignedParser;
import org.bouncycastle.mail.smime.SMIMEUtil;
import org.bouncycastle.mail.smime.handlers.multipart_signed;
import org.bouncycastle.mail.smime.handlers.pkcs7_mime;
import org.bouncycastle.mail.smime.handlers.pkcs7_signature;
import org.bouncycastle.mail.smime.handlers.x_pkcs7_mime;
import org.bouncycastle.mail.smime.handlers.x_pkcs7_signature;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BCCryptoHelper
implements ICryptoHelper {
    public static final String DEFAULT_SECURITY_PROVIDER_NAME;
    private static final Logger LOGGER;
    private static final File DUMP_DECRYPTED_DIR_PATH;
    private static final byte[] EOL_BYTES;
    private String m_sSecurityProviderName = DEFAULT_SECURITY_PROVIDER_NAME;
    private static Map<ASN1ObjectIdentifier, String> NEW_SIGN_ALGOS;

    public BCCryptoHelper() {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-signature;; x-java-content-handler=" + pkcs7_signature.class.getName());
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=" + pkcs7_mime.class.getName());
        mailcapCommandMap.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=" + x_pkcs7_signature.class.getName());
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=" + x_pkcs7_mime.class.getName());
        mailcapCommandMap.addMailcap("multipart/signed;; x-java-content-handler=" + multipart_signed.class.getName());
        AccessControllerHelper.run(() -> {
            CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
            return null;
        });
    }

    @Nonnull
    @Nonempty
    public String getSecurityProviderName() {
        return this.m_sSecurityProviderName;
    }

    @Nonnull
    public BCCryptoHelper setSecurityProviderName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"SecurityProviderName");
        this.m_sSecurityProviderName = string;
        return this;
    }

    @Override
    @Nonnull
    public KeyStore createNewKeyStore(@Nonnull IKeyStoreType iKeyStoreType) throws GeneralSecurityException {
        try {
            return iKeyStoreType.getKeyStore(this.m_sSecurityProviderName);
        }
        catch (Exception exception) {
            return iKeyStoreType.getKeyStore();
        }
    }

    @Override
    @Nonnull
    public KeyStore loadKeyStore(@Nonnull IKeyStoreType iKeyStoreType, @Nullable @WillNotClose InputStream inputStream, @Nonnull char[] cArray) throws Exception {
        KeyStore keyStore = this.createNewKeyStore(iKeyStoreType);
        if (inputStream != null) {
            keyStore.load(inputStream, cArray);
        }
        return keyStore;
    }

    @Override
    public boolean isEncrypted(@Nonnull MimeBodyPart mimeBodyPart) throws MessagingException {
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"Part");
        ContentType contentType = AS2HttpHelper.parseContentType(mimeBodyPart.getContentType());
        if (contentType == null) {
            return false;
        }
        String string = contentType.getBaseType().toLowerCase(Locale.US);
        if (!string.equals("application/pkcs7-mime")) {
            return false;
        }
        String string2 = contentType.getParameter("smime-type");
        return string2 != null && string2.equalsIgnoreCase("enveloped-data");
    }

    @Override
    public boolean isSigned(@Nonnull MimeBodyPart mimeBodyPart) throws MessagingException {
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"Part");
        ContentType contentType = AS2HttpHelper.parseContentType(mimeBodyPart.getContentType());
        if (contentType == null) {
            return false;
        }
        String string = contentType.getBaseType();
        return string.equalsIgnoreCase("multipart/signed");
    }

    @Override
    public boolean isCompressed(@Nonnull String string) throws AS2Exception {
        ValueEnforcer.notNull((Object)string, (String)"ContentType");
        ContentType contentType = AS2HttpHelper.parseContentType(string);
        if (contentType == null) {
            return false;
        }
        String string2 = contentType.getParameter("smime-type");
        return string2 != null && string2.equalsIgnoreCase("compressed-data");
    }

    @Override
    @Nonnull
    public MIC calculateMIC(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull ECryptoAlgorithmSign eCryptoAlgorithmSign, boolean bl) throws GeneralSecurityException, MessagingException, IOException {
        Object object;
        Object object2;
        Object object3;
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"MimeBodyPart");
        ValueEnforcer.notNull((Object)eCryptoAlgorithmSign, (String)"DigestAlgorithm");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BCCryptoHelper.calculateMIC (" + eCryptoAlgorithmSign + " [" + eCryptoAlgorithmSign.getOID().getId() + "], " + bl + ")");
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCryptoAlgorithmSign.getOID();
        MessageDigest messageDigest = MessageDigest.getInstance(aSN1ObjectIdentifier.getId(), this.m_sSecurityProviderName);
        if (bl) {
            object3 = mimeBodyPart.getAllHeaderLines();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                messageDigest.update(AS2IOHelper.getAllAsciiBytes((String)object2));
                messageDigest.update(EOL_BYTES);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Using header line '" + (String)object2 + "' for MIC calculation");
            }
            messageDigest.update(EOL_BYTES);
        }
        object3 = mimeBodyPart.getEncoding();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((String)(object3 != null ? "Using Content-Transfer-Encoding '" + (String)object3 + "' for MIC calculation" : "Using no specific Content-Transfer-Encoding for MIC calculation"));
        }
        object2 = new DigestOutputStream((OutputStream)new NullOutputStream(), messageDigest);
        try {
            object = AS2IOHelper.getContentTransferEncodingAwareOutputStream((OutputStream)object2, (String)object3);
            try {
                mimeBodyPart.getDataHandler().writeTo((OutputStream)object);
            }
            finally {
                if (object != null) {
                    ((OutputStream)object).close();
                }
            }
        }
        finally {
            ((FilterOutputStream)object2).close();
        }
        object2 = messageDigest.digest();
        object = new MIC((byte[])object2, eCryptoAlgorithmSign);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("  Calculated MIC = " + ((MIC)object).getAsAS2String());
        }
        return object;
    }

    private static void _dumpDecrypted(@Nonnull byte[] byArray) {
        File file;
        int n = 0;
        do {
            file = new File(DUMP_DECRYPTED_DIR_PATH, "as2-decrypted-" + Long.toString(PDTFactory.getCurrentMillis()) + "-" + n + ".part");
            ++n;
        } while (file.exists());
        LOGGER.info("Dumping decrypted MIME part to file " + file.getAbsolutePath());
        try (FileOutputStream fileOutputStream = FileHelper.getOutputStream((File)file);){
            ((OutputStream)fileOutputStream).write(byArray);
        }
        catch (IOException iOException) {
            LOGGER.error("Failed to dump decrypted MIME part to file " + file.getAbsolutePath(), (Throwable)iOException);
        }
    }

    @Override
    @Nonnull
    public MimeBodyPart decrypt(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull X509Certificate x509Certificate, @Nonnull PrivateKey privateKey, boolean bl, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws GeneralSecurityException, MessagingException, CMSException, SMIMEException, IOException {
        SMIMEEnvelopedParser sMIMEEnvelopedParser;
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"MimeBodyPart");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"X509Cert");
        ValueEnforcer.notNull((Object)privateKey, (String)"PrivateKey");
        ValueEnforcer.notNull((Object)aS2ResourceHelper, (String)"ResHelper");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BCCryptoHelper.decrypt; X509 subject=" + x509Certificate.getSubjectX500Principal().getName() + "; forceDecrypt=" + bl);
        }
        if (!bl && !this.isEncrypted(mimeBodyPart)) {
            throw new GeneralSecurityException("Content-Type '" + mimeBodyPart.getContentType() + "' indicates data isn't encrypted");
        }
        JceKeyTransRecipientId jceKeyTransRecipientId = new JceKeyTransRecipientId(x509Certificate);
        RecipientInformation recipientInformation = null;
        try {
            sMIMEEnvelopedParser = new SMIMEEnvelopedParser(mimeBodyPart);
            recipientInformation = sMIMEEnvelopedParser.getRecipientInfos().get((RecipientId)jceKeyTransRecipientId);
        }
        catch (Exception exception) {
            LOGGER.error("Error retrieving RecipientInformation", (Throwable)exception);
        }
        if (recipientInformation == null) {
            throw new GeneralSecurityException("Certificate does not match part signature");
        }
        sMIMEEnvelopedParser = SMIMEUtil.toMimeBodyPart((CMSTypedStream)recipientInformation.getContentStream((Recipient)new JceKeyTransEnvelopedRecipient(privateKey).setProvider(this.m_sSecurityProviderName)), (File)aS2ResourceHelper.createTempFile());
        if (DUMP_DECRYPTED_DIR_PATH != null) {
            try (NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream(sMIMEEnvelopedParser.getSize());){
                sMIMEEnvelopedParser.writeTo((OutputStream)nonBlockingByteArrayOutputStream);
                BCCryptoHelper._dumpDecrypted(nonBlockingByteArrayOutputStream.toByteArray());
            }
        }
        return sMIMEEnvelopedParser;
    }

    @Override
    @Nonnull
    public MimeBodyPart encrypt(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull X509Certificate x509Certificate, @Nonnull ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt, @Nonnull EContentTransferEncoding eContentTransferEncoding) throws GeneralSecurityException, SMIMEException, CMSException {
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"MimeBodyPart");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"X509Cert");
        ValueEnforcer.notNull((Object)eCryptoAlgorithmCrypt, (String)"Algorithm");
        ValueEnforcer.notNull((Object)eContentTransferEncoding, (String)"ContentTransferEncoding");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BCCryptoHelper.encrypt; X509 subject=" + x509Certificate.getSubjectX500Principal().getName() + "; algorithm=" + eCryptoAlgorithmCrypt + " [" + eCryptoAlgorithmCrypt.getOID().getId() + "], CTE=" + eContentTransferEncoding);
        }
        x509Certificate.checkValidity();
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCryptoAlgorithmCrypt.getOID();
        SMIMEEnvelopedGenerator sMIMEEnvelopedGenerator = new SMIMEEnvelopedGenerator();
        sMIMEEnvelopedGenerator.addRecipientInfoGenerator((RecipientInfoGenerator)new JceKeyTransRecipientInfoGenerator(x509Certificate).setProvider(this.m_sSecurityProviderName));
        sMIMEEnvelopedGenerator.setContentTransferEncoding(eContentTransferEncoding.getID());
        OutputEncryptor outputEncryptor = new JceCMSContentEncryptorBuilder(aSN1ObjectIdentifier).setProvider(this.m_sSecurityProviderName).build();
        return sMIMEEnvelopedGenerator.generate(mimeBodyPart, outputEncryptor);
    }

    @Override
    @Nonnull
    public MimeBodyPart sign(@Nonnull MimeBodyPart mimeBodyPart, @Nonnull X509Certificate x509Certificate, @Nonnull PrivateKey privateKey, @Nonnull ECryptoAlgorithmSign eCryptoAlgorithmSign, boolean bl, boolean bl2, boolean bl3, @Nonnull EContentTransferEncoding eContentTransferEncoding) throws GeneralSecurityException, SMIMEException, MessagingException, OperatorCreationException {
        CMSAttributeTableGenerator cMSAttributeTableGenerator;
        ValueEnforcer.notNull((Object)mimeBodyPart, (String)"MimeBodyPart");
        ValueEnforcer.notNull((Object)x509Certificate, (String)"X509Cert");
        ValueEnforcer.notNull((Object)privateKey, (String)"PrivateKey");
        ValueEnforcer.notNull((Object)eCryptoAlgorithmSign, (String)"Algorithm");
        ValueEnforcer.notNull((Object)eContentTransferEncoding, (String)"ContentTransferEncoding");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BCCryptoHelper.sign; X509 subject=" + x509Certificate.getSubjectX500Principal().getName() + "; algorithm=" + eCryptoAlgorithmSign + "; includeCertificateInSignedContent=" + bl + "; CTE=" + eContentTransferEncoding);
        }
        x509Certificate.checkValidity();
        CommonsArrayList commonsArrayList = new CommonsArrayList((Object)x509Certificate);
        JcaCertStore jcaCertStore = new JcaCertStore((Collection)commonsArrayList);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        SMIMECapabilityVector sMIMECapabilityVector = new SMIMECapabilityVector();
        sMIMECapabilityVector.addCapability(eCryptoAlgorithmSign.getOID());
        aSN1EncodableVector.add((ASN1Encodable)new SMIMECapabilitiesAttribute(sMIMECapabilityVector));
        SMIMESignedGenerator sMIMESignedGenerator = new SMIMESignedGenerator(bl2 ? SMIMESignedGenerator.RFC3851_MICALGS : NEW_SIGN_ALGOS);
        sMIMESignedGenerator.setContentTransferEncoding(eContentTransferEncoding.getID());
        SignerInfoGenerator signerInfoGenerator = new JcaSimpleSignerInfoGeneratorBuilder().setProvider(this.m_sSecurityProviderName).setSignedAttributeGenerator(new AttributeTable(aSN1EncodableVector)).build(eCryptoAlgorithmSign.getSignAlgorithmName(), privateKey, x509Certificate);
        if (bl3) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Removing CMS AlgorithmProtect attribute, if it is present");
            }
            cMSAttributeTableGenerator = signerInfoGenerator.getSignedAttributeTableGenerator();
            signerInfoGenerator = new SignerInfoGenerator(signerInfoGenerator, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(){

                public AttributeTable getAttributes(Map map) {
                    AttributeTable attributeTable = cMSAttributeTableGenerator.getAttributes(map);
                    return attributeTable.remove(CMSAttributes.cmsAlgorithmProtect);
                }
            }, signerInfoGenerator.getUnsignedAttributeTableGenerator());
        }
        sMIMESignedGenerator.addSignerInfoGenerator(signerInfoGenerator);
        if (bl) {
            sMIMESignedGenerator.addCertificates((Store)jcaCertStore);
        }
        signerInfoGenerator = sMIMESignedGenerator.generate(mimeBodyPart);
        cMSAttributeTableGenerator = new MimeBodyPart();
        cMSAttributeTableGenerator.setContent((Multipart)signerInfoGenerator);
        cMSAttributeTableGenerator.setHeader("Content-Type", signerInfoGenerator.getContentType());
        return cMSAttributeTableGenerator;
    }

    @Nonnull
    private X509Certificate _verifyFindCertificate(@Nullable X509Certificate x509Certificate, boolean bl, @Nonnull SMIMESignedParser sMIMESignedParser) throws CMSException, GeneralSecurityException {
        X509Certificate x509Certificate2 = x509Certificate;
        if (bl) {
            Object object;
            SignerId signerId = null;
            Collection collection = sMIMESignedParser.getSignerInfos().getSigners();
            Iterator iterator = collection.iterator();
            if (iterator.hasNext()) {
                object = (SignerInformation)iterator.next();
                signerId = object.getSID();
            }
            if (!(object = sMIMESignedParser.getCertificates().getMatches(signerId)).isEmpty()) {
                if (object.size() > 1) {
                    LOGGER.warn("Signed part contains " + object.size() + " certificates - using the first one!");
                }
                X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)CollectionHelper.getFirstElement((Collection)object);
                X509Certificate x509Certificate3 = new JcaX509CertificateConverter().setProvider(this.m_sSecurityProviderName).getCertificate(x509CertificateHolder);
                if (x509Certificate != null && !x509Certificate.equals(x509Certificate3)) {
                    LOGGER.warn("Certificate mismatch! Provided certificate\n" + x509Certificate + " differs from certficate contained in message\n" + x509Certificate3);
                }
                x509Certificate2 = x509Certificate3;
            }
        }
        if (x509Certificate2 == null) {
            throw new GeneralSecurityException("No certificate provided" + (bl ? " and none found in the message" : "") + "!");
        }
        return x509Certificate2;
    }

    @Override
    @Nonnull
    public MimeBodyPart verify(@Nonnull MimeBodyPart mimeBodyPart, @Nullable X509Certificate x509Certificate, boolean bl, boolean bl2, @Nullable Consumer<X509Certificate> consumer, @Nonnull AS2ResourceHelper aS2ResourceHelper) throws GeneralSecurityException, IOException, MessagingException, CMSException, OperatorCreationException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BCCryptoHelper.verify; X509 subject=" + (x509Certificate == null ? "null" : x509Certificate.getSubjectX500Principal().getName()) + "; useCertificateInBodyPart=" + bl + "; forceVerify=" + bl2);
        }
        if (!bl2 && !this.isSigned(mimeBodyPart)) {
            throw new GeneralSecurityException("Content-Type indicates data isn't signed: " + mimeBodyPart.getContentType());
        }
        Object object = mimeBodyPart.getContent();
        if (!(object instanceof MimeMultipart)) {
            throw new IllegalStateException("Expected Part content to be MimeMultipart but it isn't. It is " + ClassHelper.getClassName((Object)object));
        }
        MimeMultipart mimeMultipart = (MimeMultipart)object;
        SMIMESignedParser sMIMESignedParser = new SMIMESignedParser(new JcaDigestCalculatorProviderBuilder().setProvider(this.m_sSecurityProviderName).build(), mimeMultipart, EContentTransferEncoding.AS2_DEFAULT.getID(), aS2ResourceHelper.createTempFile());
        X509Certificate x509Certificate2 = this._verifyFindCertificate(x509Certificate, bl, sMIMESignedParser);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(EqualsHelper.identityEqual((Object)x509Certificate2, (Object)x509Certificate) ? "Verifying signature using the provided certificate (partnership)" : "Verifying signature using the certificate contained in the MIME body part");
        }
        if (consumer != null) {
            consumer.accept(x509Certificate2);
        }
        x509Certificate2.checkValidity();
        SignerInformationVerifier signerInformationVerifier = new JcaSimpleSignerInfoVerifierBuilder().setProvider(this.m_sSecurityProviderName).build(x509Certificate2.getPublicKey());
        for (SignerInformation signerInformation : sMIMESignedParser.getSignerInfos().getSigners()) {
            if (signerInformation.verify(signerInformationVerifier)) continue;
            throw new SignatureException("Verification failed for SignerInfo " + signerInformation);
        }
        return sMIMESignedParser.getContent();
    }

    static {
        ECryptoAlgorithmSign[] eCryptoAlgorithmSignArray;
        Object object;
        LOGGER = LoggerFactory.getLogger(BCCryptoHelper.class);
        EOL_BYTES = AS2IOHelper.getAllAsciiBytes("\r\n");
        try {
            Class.forName("org.bouncycastle.jce.provider.BouncyCastleProvider");
            object = PBCProvider.getProvider().getName();
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Class.forName("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
                object = "BCFIPS";
                if (Security.getProvider((String)object) == null) {
                    Security.addProvider((Provider)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
            }
            catch (Exception exception2) {
                throw new IllegalStateException("Neither regular BouncyCastle nor BouncyCastle FIPS are in the classpath", exception2);
            }
        }
        DEFAULT_SECURITY_PROVIDER_NAME = object;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using security provider '" + DEFAULT_SECURITY_PROVIDER_NAME + "'.");
        }
        if (StringHelper.hasText((String)(eCryptoAlgorithmSignArray = SystemProperties.getPropertyValueOrNull((String)"AS2.dumpDecryptedDirectory")))) {
            DUMP_DECRYPTED_DIR_PATH = new File((String)eCryptoAlgorithmSignArray);
            AS2IOHelper.getFileOperationManager().createDirIfNotExisting(DUMP_DECRYPTED_DIR_PATH);
            LOGGER.info("Using directory " + DUMP_DECRYPTED_DIR_PATH.getAbsolutePath() + " to dump all decrypted AS2 body parts to.");
        } else {
            DUMP_DECRYPTED_DIR_PATH = null;
        }
        object = new LinkedHashMap(SMIMESignedGenerator.RFC5751_MICALGS);
        for (ECryptoAlgorithmSign eCryptoAlgorithmSign : ECryptoAlgorithmSign.values()) {
            if (eCryptoAlgorithmSign.isRFC3851Algorithm()) continue;
            object.computeIfAbsent(eCryptoAlgorithmSign.getOID(), aSN1ObjectIdentifier -> eCryptoAlgorithmSign.getMICAlgorithmID());
        }
        NEW_SIGN_ALGOS = Collections.unmodifiableMap(object);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The current algorithms for RFC 5751 mode are " + NEW_SIGN_ALGOS);
        }
    }
}

