/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.cert;

import com.helger.as2lib.cert.AbstractCertificateFactory;
import com.helger.as2lib.cert.IStorableCertificateFactory;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CertificateFactory
extends AbstractCertificateFactory
implements IStorableCertificateFactory {
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_SAVE_CHANGES_TO_FILE = "autosave";
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateFactory.class);

    @Override
    public void setFilename(@Nullable String string) {
        this.debugLog(() -> "setFilename (" + string + ")");
        this.m_aRWLock.writeLocked(() -> this.attrs().putIn((Object)ATTR_FILENAME, (Object)string));
    }

    @Override
    @Nullable
    public String getFilename() {
        this.debugLog(() -> "getFilename ()");
        String string = (String)this.m_aRWLock.readLockedGet(() -> this.attrs().getAsString((Object)ATTR_FILENAME));
        this.debugLog(() -> "getFilename -> " + string);
        return string;
    }

    @Override
    public void setSaveChangesToFile(boolean bl) {
        this.debugLog(() -> "setSaveChangesToFile (" + bl + ")");
        this.m_aRWLock.writeLocked(() -> this.attrs().putIn(ATTR_SAVE_CHANGES_TO_FILE, bl));
    }

    @Override
    public boolean isSaveChangesToFile() {
        this.debugLog(() -> "isSaveChangesToFile ()");
        boolean bl = this.m_aRWLock.readLockedBoolean(() -> this.attrs().getAsBoolean((Object)ATTR_SAVE_CHANGES_TO_FILE, true));
        this.debugLog(() -> "isSaveChangesToFile -> " + bl);
        return bl;
    }

    @Override
    public void reinitKeyStore() throws AS2Exception {
        this.debugLog(() -> "reinitKeyStore ()");
        this.initEmptyKeyStore();
        String string = this.getFilename();
        if (StringHelper.hasText((String)string)) {
            this.load(string, this.getPassword());
        }
        this.debugLog(() -> "reinitKeyStore -> done");
    }

    @Override
    @OverrideOnDemand
    protected void onChange() throws AS2Exception {
        this.debugLog(() -> "onChange ()");
        if (this.isSaveChangesToFile()) {
            String string = this.getFilename();
            if (StringHelper.hasText((String)string)) {
                this.save(string, this.getPassword());
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Something changed in the keystore, but because no filename is present, changes are not saved");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Something changed in the keystore, saving of changes is disabled");
        }
        this.debugLog(() -> "onChange -> done");
    }
}

