/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util.http;

import com.helger.as2lib.util.http.IAS2HttpRequestDataProvider;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import com.helger.commons.io.stream.NonClosingInputStream;
import com.helger.commons.io.stream.StreamHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import javax.annotation.concurrent.Immutable;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;

@Immutable
public class AS2HttpRequestDataProviderInputStream
implements IAS2HttpRequestDataProvider {
    @WillNotClose
    private final InputStream m_aIS;
    private final String m_sHttpRequestMethod;
    private final String m_sHttpRequestUrl;
    private final String m_sHttpRequestVersion;
    private final HttpHeaderMap m_aHttpHeaders = new HttpHeaderMap();

    @Nonnull
    @Nonempty
    private static String[] _readRequestInfo(@Nonnull InputStream inputStream) throws IOException {
        StringTokenizer stringTokenizer;
        int n;
        int n2 = inputStream.read();
        StringBuilder stringBuilder = new StringBuilder();
        while (n2 != -1 && n2 != 13) {
            stringBuilder.append((char)n2);
            n2 = inputStream.read();
        }
        if (n2 != -1) {
            inputStream.read();
        }
        if ((n = (stringTokenizer = new StringTokenizer(stringBuilder.toString(), " ")).countTokens()) >= 3) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            return stringArray;
        }
        if (n == 2) {
            String[] stringArray = new String[]{stringTokenizer.nextToken(), "/", stringTokenizer.nextToken()};
            return stringArray;
        }
        throw new IOException("Invalid HTTP Request (" + stringBuilder.toString() + ")");
    }

    public AS2HttpRequestDataProviderInputStream(@Nonnull @WillNotClose InputStream inputStream) throws IOException, MessagingException {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        this.m_aIS = inputStream;
        String[] stringArray = AS2HttpRequestDataProviderInputStream._readRequestInfo(this.m_aIS);
        this.m_sHttpRequestMethod = stringArray[0];
        this.m_sHttpRequestUrl = stringArray[1];
        this.m_sHttpRequestVersion = stringArray[2];
        InternetHeaders internetHeaders = new InternetHeaders(this.m_aIS);
        Enumeration enumeration = internetHeaders.getAllHeaders();
        while (enumeration.hasMoreElements()) {
            Header header = (Header)enumeration.nextElement();
            this.m_aHttpHeaders.addHeader(header.getName(), header.getValue());
        }
    }

    @Override
    @Nonnull
    public InputStream getHttpInputStream() throws IOException {
        return StreamHelper.getBuffered((InputStream)new NonClosingInputStream(this.m_aIS));
    }

    @Override
    @Nonnull
    public String getHttpRequestMethod() {
        return this.m_sHttpRequestMethod;
    }

    @Override
    @Nonnull
    public String getHttpRequestUrl() {
        return this.m_sHttpRequestUrl;
    }

    @Override
    @Nonnull
    public String getHttpRequestVersion() {
        return this.m_sHttpRequestVersion;
    }

    @Override
    @Nonnull
    public HttpHeaderMap getHttpHeaderMap() {
        return this.m_aHttpHeaders;
    }

    @Nonnull
    public static AS2HttpRequestDataProviderInputStream createForUtf8(@Nonnull String string) throws IOException, MessagingException {
        byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
        return new AS2HttpRequestDataProviderInputStream((InputStream)new NonBlockingByteArrayInputStream(byArray));
    }
}

