/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.util;

import com.helger.as2lib.IDynamicComponent;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.session.IAS2Session;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.lang.GenericReflection;
import com.helger.xml.microdom.IMicroElement;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AS2XMLHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(AS2XMLHelper.class);
    private static final String DOLLAR_HOME_DOLLAR = "%home%";

    private AS2XMLHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static StringMap getAllAttrsWithLowercaseName(@Nonnull IMicroElement iMicroElement) {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"Element");
        StringMap stringMap = new StringMap();
        iMicroElement.forAllAttributes((string, string2, string3) -> stringMap.putIn((Object)string2.toLowerCase(Locale.US), string3));
        return stringMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static StringMap getAllAttrsWithLowercaseNameWithRequired(@Nonnull IMicroElement iMicroElement, String ... stringArray) throws AS2Exception {
        StringMap stringMap = AS2XMLHelper.getAllAttrsWithLowercaseName(iMicroElement);
        for (String string : stringArray) {
            if (stringMap.containsKey((Object)string)) continue;
            throw new AS2Exception(iMicroElement.getTagName() + " is missing required attribute '" + string + "'");
        }
        return stringMap;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsOrderedMap<String, String> mapAttributeNodes(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2, @Nonnull String string3) throws AS2Exception {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"Node");
        ValueEnforcer.notNull((Object)string, (String)"NodeName");
        ValueEnforcer.notNull((Object)string2, (String)"NodeKeyName");
        ValueEnforcer.notNull((Object)string3, (String)"NodeValueName");
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        int n = 0;
        for (IMicroElement iMicroElement2 : iMicroElement.getAllChildElements(string)) {
            String string4 = iMicroElement2.getAttributeValue(string2);
            if (string4 == null) {
                throw new AS2Exception(string + "[" + n + "] does not have key attribute '" + string2 + "'");
            }
            String string5 = iMicroElement2.getAttributeValue(string3);
            if (string5 == null) {
                throw new AS2Exception(string + "[" + n + "] does not have value attribute '" + string3 + "'");
            }
            commonsLinkedHashMap.put((Object)string4, (Object)string5);
            ++n;
        }
        return commonsLinkedHashMap;
    }

    private static void _updateDirectories(@Nonnull StringMap stringMap, @Nullable String string) throws AS2Exception {
        for (Map.Entry entry : stringMap.entrySet()) {
            String string2 = (String)entry.getValue();
            if (!string2.startsWith(DOLLAR_HOME_DOLLAR)) continue;
            if (string == null) {
                throw new AS2Exception("Base directory isn't set");
            }
            stringMap.putIn(entry.getKey(), (Object)(string + string2.substring(DOLLAR_HOME_DOLLAR.length())));
        }
    }

    @Nonnull
    public static <T extends IDynamicComponent> T createComponent(@Nonnull IMicroElement iMicroElement, @Nonnull Class<T> clazz, @Nonnull IAS2Session iAS2Session, @Nullable String string) throws AS2Exception {
        ValueEnforcer.notNull((Object)iMicroElement, (String)"Element");
        ValueEnforcer.notNull(clazz, (String)"Class");
        ValueEnforcer.notNull((Object)iAS2Session, (String)"Session");
        String string2 = iMicroElement.getAttributeValue("classname");
        if (string2 == null) {
            throw new AS2Exception("Missing 'classname' attribute");
        }
        try {
            IDynamicComponent iDynamicComponent;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Trying to instantiate '" + string2 + "' as a " + clazz);
            }
            if ((iDynamicComponent = (IDynamicComponent)GenericReflection.newInstance((String)string2, clazz)) == null) {
                throw new AS2Exception("Failed to instantiate '" + string2 + "' as " + clazz.getName());
            }
            StringMap stringMap = AS2XMLHelper.getAllAttrsWithLowercaseName(iMicroElement);
            if (string != null) {
                AS2XMLHelper._updateDirectories(stringMap, string);
            }
            iDynamicComponent.initDynamicComponent(iAS2Session, (IStringMap)stringMap);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Finished initializing " + iDynamicComponent);
            }
            return (T)iDynamicComponent;
        }
        catch (AS2Exception aS2Exception) {
            throw aS2Exception;
        }
        catch (Exception exception) {
            throw new AS2Exception("Error creating component: " + string2, exception);
        }
    }
}

