/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.resender;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.resender.AbstractResenderModule;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmediateResenderModule
extends AbstractResenderModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmediateResenderModule.class);

    @Override
    public boolean canHandle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) {
        return string.equals("resend");
    }

    @Override
    public void handle(@Nonnull String string, @Nonnull IMessage iMessage, @Nullable Map<String, Object> map) throws AS2Exception {
        int n;
        String string2;
        String string3;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Immediately resending message" + iMessage.getLoggingText());
        }
        String string4 = string3 = map == null ? null : (String)map.get("resend_method");
        if (string3 == null) {
            LOGGER.warn("The resending action is missing - default to message sending!");
            string3 = "send";
        }
        String string5 = string2 = map == null ? null : (String)map.get("retries");
        if (string2 != null) {
            n = Integer.parseInt(string2);
        } else {
            n = 0;
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("The resending retry count is missing - default to " + n + "!");
            }
        }
        --n;
        if (map != null) {
            map.put("retries", Integer.toString(n));
        }
        this.getSession().getMessageProcessor().handle(string3, iMessage, map);
    }
}

