/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor.receiver;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.exception.WrappedAS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.params.AS2InvalidParameterException;
import com.helger.as2lib.params.CompositeParameters;
import com.helger.as2lib.params.DateParameters;
import com.helger.as2lib.params.MessageParameters;
import com.helger.as2lib.processor.receiver.AS2InvalidMessageException;
import com.helger.as2lib.processor.receiver.AbstractActivePollingModule;
import com.helger.as2lib.session.IAS2Session;
import com.helger.as2lib.util.AS2IOHelper;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.io.file.FileIOError;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.SimpleFileIO;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.string.StringHelper;
import com.helger.mail.cte.EContentTransferEncoding;
import com.helger.mail.datasource.ByteArrayDataSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDirectoryPollingModule
extends AbstractActivePollingModule {
    public static final String ATTR_OUTBOX_DIRECTORY = "outboxdir";
    public static final String ATTR_ERROR_DIRECTORY = "errordir";
    public static final String ATTR_STORED_ERROR_FILENAME = "stored_error_filename";
    public static final String ATTR_SENT_DIRECTORY = "sentdir";
    public static final String ATTR_STORED_SENT_FILENAME = "stored_sent_filename";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_DELIMITERS = "delimiters";
    public static final String ATTR_DEFAULTS = "defaults";
    public static final String ATTR_MIMETYPE = "mimetype";
    public static final String ATTR_SENDFILENAME = "sendfilename";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDirectoryPollingModule.class);
    private ICommonsMap<String, Long> m_aTrackedFiles;

    @Override
    public void initDynamicComponent(@Nonnull IAS2Session iAS2Session, @Nullable IStringMap iStringMap) throws AS2Exception {
        super.initDynamicComponent(iAS2Session, iStringMap);
        this.getAttributeAsStringRequired(ATTR_OUTBOX_DIRECTORY);
        this.getAttributeAsStringRequired(ATTR_ERROR_DIRECTORY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean checkFile(@Nonnull File file) {
        if (!file.exists()) return false;
        if (!file.isFile()) return false;
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, true);){
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Nonnull
    @ReturnsMutableObject
    public final ICommonsMap<String, Long> trackedFiles() {
        if (this.m_aTrackedFiles == null) {
            this.m_aTrackedFiles = new CommonsHashMap();
        }
        return this.m_aTrackedFiles;
    }

    protected void trackFile(@Nonnull File file) {
        ICommonsMap<String, Long> iCommonsMap = this.trackedFiles();
        iCommonsMap.computeIfAbsent((Object)file.getAbsolutePath(), string -> file.length());
    }

    protected void scanDirectory(String string) throws AS2InvalidParameterException {
        File file;
        File[] fileArray;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Polling - scanning directory '" + string + "'");
        }
        if ((fileArray = (file = AS2IOHelper.getDirectoryFile(string)).listFiles()) == null) {
            throw new AS2InvalidParameterException("Error getting list of files in directory", this, ATTR_OUTBOX_DIRECTORY, file.getAbsolutePath());
        }
        if (fileArray.length > 0) {
            for (File file2 : fileArray) {
                if (!this.checkFile(file2)) continue;
                this.trackFile(file2);
            }
        }
    }

    @Nonnull
    protected abstract IMessage createMessage();

    protected void processFile(@Nonnull File file) throws AS2Exception {
        block14: {
            LOGGER.info("processing " + file.getAbsolutePath());
            IMessage iMessage = this.createMessage();
            iMessage.attrs().putIn((Object)"filepath", (Object)file.getAbsolutePath());
            iMessage.attrs().putIn((Object)"filename", (Object)file.getName());
            iMessage.attrs().putIn((Object)"pendingfilename", (Object)file.getName());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("AS2Message was created");
            }
            CompositeParameters compositeParameters = new CompositeParameters(false).add("date", new DateParameters()).add("msg", new MessageParameters(iMessage));
            try {
                Object object;
                String string;
                Object object2;
                this.updateMessage(iMessage, file);
                LOGGER.info("file assigned to message " + file.getAbsolutePath() + iMessage.getLoggingText());
                if (iMessage.getData() == null) {
                    throw new AS2InvalidMessageException("No Data");
                }
                this.getSession().getMessageProcessor().handle("send", iMessage, null);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("AS2Message was successfully handled my the MessageProcessor");
                }
                if ("pending".equals(iMessage.attrs().getAsString((Object)"status"))) {
                    object2 = AS2IOHelper.getSafeFileAndFolderName(iMessage.partnership().getAttribute("pending"));
                    string = FilenameHelper.getAsSecureValidASCIIFilename((String)iMessage.attrs().getAsString((Object)"pendingfilename"));
                    object = new File((String)object2, string);
                    FileIOError fileIOError = AS2IOHelper.getFileOperationManager().copyFile(file, (File)object);
                    if (fileIOError.isFailure()) {
                        throw new AS2Exception("File was successfully sent but not copied to pending folder: " + object + " - " + fileIOError.toString());
                    }
                    LOGGER.info("Copied '" + file.getAbsolutePath() + "' to pending folder '" + ((File)object).getAbsolutePath() + "'" + iMessage.getLoggingText());
                }
                if (this.attrs().containsKey((Object)ATTR_SENT_DIRECTORY)) {
                    object2 = null;
                    try {
                        string = AS2IOHelper.getSafeFileAndFolderName(compositeParameters.format(this.attrs().getAsString((Object)ATTR_SENT_DIRECTORY)));
                        object = StringHelper.getNotEmpty((String)FilenameHelper.getAsSecureValidASCIIFilename((String)compositeParameters.format(this.attrs().getAsString((Object)ATTR_STORED_SENT_FILENAME))), (String)file.getName());
                        object2 = new File(AS2IOHelper.getDirectoryFile(string), (String)object);
                        object2 = AS2IOHelper.moveFile(file, (File)object2, false, true);
                        if (LOGGER.isInfoEnabled()) {
                            LOGGER.info("Moved '" + file.getAbsolutePath() + "' to '" + ((File)object2).getAbsolutePath() + "'" + iMessage.getLoggingText());
                        }
                        break block14;
                    }
                    catch (IOException iOException) {
                        new AS2Exception("File was successfully sent but not moved to sent folder: '" + ((File)object2).getAbsolutePath() + "'", iOException).terminate();
                    }
                    break block14;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Trying to delete file " + file.getAbsolutePath());
                }
                if (AS2IOHelper.getFileOperationManager().deleteFileIfExisting(file).isFailure()) {
                    throw new AS2Exception("File was successfully sent but not deleted: '" + file.getAbsolutePath() + "'");
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Deleted file '" + file.getAbsolutePath() + "'" + iMessage.getLoggingText());
                }
            }
            catch (AS2Exception aS2Exception) {
                aS2Exception.terminate(file, iMessage);
                String string = AS2IOHelper.getSafeFileAndFolderName(compositeParameters.format(this.getAttributeAsStringRequired(ATTR_ERROR_DIRECTORY)));
                String string2 = StringHelper.getNotEmpty((String)FilenameHelper.getAsSecureValidASCIIFilename((String)compositeParameters.format(this.attrs().getAsString((Object)ATTR_STORED_ERROR_FILENAME))), (String)file.getName());
                AS2IOHelper.handleError(file, string, string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTracking() throws AS2Exception {
        ICommonsMap<String, Long> iCommonsMap = this.trackedFiles();
        for (Map.Entry entry : ((ICommonsMap)iCommonsMap.getClone()).entrySet()) {
            File file = new File((String)entry.getKey());
            long l = (Long)entry.getValue();
            if (!this.checkFile(file)) {
                iCommonsMap.remove(entry.getKey());
                continue;
            }
            long l2 = file.length();
            if (l2 != l) {
                iCommonsMap.put(entry.getKey(), (Object)l2);
                continue;
            }
            try {
                this.processFile(file);
            }
            finally {
                iCommonsMap.remove(entry.getKey());
            }
        }
    }

    public void updateMessage(@Nonnull IMessage iMessage, @Nonnull File file) throws AS2Exception {
        Object object;
        MessageParameters messageParameters = new MessageParameters(iMessage);
        String string = this.attrs().getAsString((Object)ATTR_DEFAULTS);
        if (string != null) {
            messageParameters.setParameters(string);
        }
        String string2 = file.getName();
        String string3 = this.attrs().getAsString((Object)ATTR_FORMAT);
        if (string3 != null) {
            object = this.attrs().getAsString((Object)ATTR_DELIMITERS, ".-");
            messageParameters.setParameters(string3, (String)object, string2);
        }
        try {
            object = SimpleFileIO.getAllFileBytes((File)file);
            String string4 = this.attrs().getAsString((Object)ATTR_MIMETYPE);
            if (string4 == null) {
                string4 = CMimeType.APPLICATION_OCTET_STREAM.getAsString();
            } else {
                try {
                    string4 = messageParameters.format(string4);
                }
                catch (AS2InvalidParameterException aS2InvalidParameterException) {
                    LOGGER.error("Bad content-type '" + string4 + "'" + iMessage.getLoggingText());
                    string4 = CMimeType.APPLICATION_OCTET_STREAM.getAsString();
                }
            }
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(object, string4, null);
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setDataHandler(byteArrayDataSource.getAsDataHandler());
            String string5 = iMessage.partnership().getContentTransferEncodingSend(EContentTransferEncoding.AS2_DEFAULT.getID());
            mimeBodyPart.setHeader("Content-Transfer-Encoding", string5);
            mimeBodyPart.setHeader("Content-Type", string4);
            String string6 = this.attrs().getAsString((Object)ATTR_SENDFILENAME);
            if ("true".equals(string6)) {
                String string7 = iMessage.attrs().getAsString((Object)"filename");
                String string8 = "Attachment; filename=\"" + string7 + "\"";
                mimeBodyPart.setHeader("Content-Disposition", string8);
                iMessage.setContentDisposition(string8);
            }
            iMessage.setData(mimeBodyPart);
        }
        catch (MessagingException messagingException) {
            throw WrappedAS2Exception.wrap(messagingException);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updating partnership for AS2 message" + iMessage.getLoggingText());
        }
        this.getSession().getPartnershipFactory().updatePartnership(iMessage, true);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished updating partnership for AS2 message");
        }
        iMessage.updateMessageID();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Updated message ID to " + iMessage.getMessageID());
        }
    }

    @Override
    public void poll() {
        try {
            this.scanDirectory(this.getAttributeAsStringRequired(ATTR_OUTBOX_DIRECTORY));
            this.updateTracking();
        }
        catch (Exception exception) {
            WrappedAS2Exception.wrap(exception).terminate();
            this.forceStop(exception);
        }
    }
}

