/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor;

import com.helger.as2lib.IDynamicComponent;
import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.message.IMessage;
import com.helger.as2lib.processor.module.IProcessorActiveModule;
import com.helger.as2lib.processor.module.IProcessorModule;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMessageProcessor
extends IDynamicComponent {
    public static final String ATTR_PENDINGMDN = "pendingmdn";
    public static final String ATTR_PENDINGMDNINFO = "pendingmdninfo";

    @Nullable
    default public String getPendingMDNFolder() {
        return this.attrs().getAsString((Object)ATTR_PENDINGMDN);
    }

    default public void setPendingMDNFolder(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PendingMDNFolder");
        this.attrs().putIn((Object)ATTR_PENDINGMDN, (Object)string);
    }

    @Nullable
    default public String getPendingMDNInfoFolder() {
        return this.attrs().getAsString((Object)ATTR_PENDINGMDNINFO);
    }

    default public void setPendingMDNInfoFolder(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"PendingMDNInfoFolder");
        this.attrs().putIn((Object)ATTR_PENDINGMDNINFO, (Object)string);
    }

    public void handle(@Nonnull String var1, @Nonnull IMessage var2, @Nullable Map<String, Object> var3) throws AS2Exception;

    public void addModule(@Nonnull IProcessorModule var1);

    @Nonnull
    public EChange removeModule(@Nullable IProcessorModule var1);

    @Nonnegative
    public int getModuleCount();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IProcessorModule> getAllModules();

    @Nullable
    public <T extends IProcessorModule> T getModuleOfClass(@Nonnull Class<T> var1);

    @Nonnull
    @ReturnsMutableCopy
    public <T extends IProcessorModule> ICommonsList<T> getAllModulesOfClass(@Nonnull Class<T> var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IProcessorActiveModule> getAllActiveModules();

    public void startActiveModules();

    public void stopActiveModules();
}

