/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.processor;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.processor.IMessageProcessor;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.StackTraceHelper;
import java.util.List;
import javax.annotation.Nonnull;

public class AS2ProcessorException
extends AS2Exception {
    private final transient IMessageProcessor m_aProcessor;
    private final ICommonsList<AS2Exception> m_aCauses;

    public AS2ProcessorException(@Nonnull IMessageProcessor iMessageProcessor, @Nonnull @Nonempty List<? extends AS2Exception> list) {
        super("Processor '" + ClassHelper.getClassLocalName((Object)iMessageProcessor) + "' threw " + (list.size() == 1 ? "exception:" : "exceptions:"));
        ValueEnforcer.notNull((Object)iMessageProcessor, (String)"Processor");
        ValueEnforcer.notEmptyNoNullValue(list, (String)"causes");
        this.m_aProcessor = iMessageProcessor;
        this.m_aCauses = new CommonsArrayList(list);
    }

    @Nonnull
    public final IMessageProcessor getProcessor() {
        return this.m_aProcessor;
    }

    @Nonnull
    private static String _getMessage(@Nonnull @Nonempty Iterable<? extends Throwable> iterable, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Throwable throwable : iterable) {
            stringBuilder.append("\r\n");
            if (bl) {
                stringBuilder.append(StackTraceHelper.getStackAsString((Throwable)throwable, (boolean)true, (String)"\r\n"));
                continue;
            }
            stringBuilder.append(throwable.getMessage());
        }
        return stringBuilder.toString();
    }

    @Override
    public String getMessage() {
        return this.getMessage(true);
    }

    @Nonnull
    public String getMessage(boolean bl) {
        return super.getMessage() + AS2ProcessorException._getMessage(this.m_aCauses, bl);
    }

    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public final ICommonsList<AS2Exception> getAllCauses() {
        return (ICommonsList)this.m_aCauses.getClone();
    }

    @Nonnull
    public String getShortToString() {
        return this.getClass().getName() + ": " + this.getMessage(false);
    }
}

