/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.partner.xml;

import com.helger.as2lib.exception.AS2Exception;
import com.helger.as2lib.partner.xml.IPartnerMap;
import com.helger.as2lib.partner.xml.Partner;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PartnerMap
implements IPartnerMap {
    private final ICommonsOrderedMap<String, Partner> m_aMap = new CommonsLinkedHashMap();

    public void addPartner(@Nonnull Partner partner) throws AS2Exception {
        ValueEnforcer.notNull((Object)partner, (String)"NewPartner");
        String string = partner.getName();
        if (this.m_aMap.containsKey((Object)string)) {
            throw new AS2Exception("Partner is defined more than once: '" + string + "'");
        }
        this.m_aMap.put((Object)string, (Object)partner);
    }

    public void setPartners(@Nonnull PartnerMap partnerMap) {
        ValueEnforcer.notNull((Object)partnerMap, (String)"Partners");
        this.m_aMap.setAll(partnerMap.m_aMap);
    }

    @Nonnull
    public EChange removePartner(@Nullable String string) {
        return this.m_aMap.removeObject((Object)string);
    }

    @Override
    @Nullable
    public Partner getPartnerOfName(@Nullable String string) {
        return (Partner)this.m_aMap.get((Object)string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllPartnerNames() {
        return this.m_aMap.copyOfKeySet();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Partner> getAllPartners() {
        return this.m_aMap.copyOfValues();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Map", this.m_aMap).getToString();
    }
}

