/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.partner;

import com.helger.as2lib.partner.IPartnershipMap;
import com.helger.as2lib.partner.Partnership;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EChange;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PartnershipMap
implements IPartnershipMap {
    private final ICommonsOrderedMap<String, Partnership> m_aMap = new CommonsLinkedHashMap();

    public void setPartnerships(@Nonnull PartnershipMap partnershipMap) {
        ValueEnforcer.notNull((Object)partnershipMap, (String)"Partnerships");
        this.m_aMap.setAll(partnershipMap.m_aMap);
    }

    @Nonnull
    public EChange addPartnership(@Nonnull Partnership partnership) {
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        String string = partnership.getName();
        if (this.m_aMap.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put((Object)string, (Object)partnership);
        return EChange.CHANGED;
    }

    public void setPartnership(@Nonnull Partnership partnership) {
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        this.m_aMap.put((Object)partnership.getName(), (Object)partnership);
    }

    @Nonnull
    public EChange removePartnership(@Nonnull Partnership partnership) {
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        return EChange.valueOf((this.m_aMap.remove((Object)partnership.getName()) != null ? 1 : 0) != 0);
    }

    @Override
    @Nullable
    public Partnership getPartnershipByName(@Nullable String string) {
        return (Partnership)this.m_aMap.get((Object)string);
    }

    private static boolean _arePartnerIDsPresent(@Nonnull IStringMap iStringMap, @Nonnull IStringMap iStringMap2) {
        if (iStringMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : iStringMap.entrySet()) {
            String string;
            String string2 = (String)entry.getValue();
            if (EqualsHelper.equals((Object)string2, (Object)(string = iStringMap2.getAsString(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public Partnership getPartnershipByID(@Nonnull IStringMap iStringMap, @Nonnull IStringMap iStringMap2) {
        for (Partnership partnership : this.m_aMap.values()) {
            IStringMap iStringMap3;
            IStringMap iStringMap4 = partnership.getAllSenderIDs();
            if (!PartnershipMap._arePartnerIDsPresent(iStringMap, iStringMap4) || !PartnershipMap._arePartnerIDsPresent(iStringMap2, iStringMap3 = partnership.getAllReceiverIDs())) continue;
            return partnership;
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllPartnershipNames() {
        return this.m_aMap.copyOfKeySet();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<Partnership> getAllPartnerships() {
        return this.m_aMap.copyOfValues();
    }
}

