/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.partner;

import com.helger.as2lib.crypto.ECompressionType;
import com.helger.as2lib.crypto.ECryptoAlgorithmCrypt;
import com.helger.as2lib.crypto.ECryptoAlgorithmSign;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import com.helger.mail.cte.EContentTransferEncoding;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Partnership
implements Serializable {
    public static final String DEFAULT_NAME = "auto-created-dummy";
    private String m_sName;
    private final StringMap m_aSenderAttrs = new StringMap();
    private final StringMap m_aReceiverAttrs = new StringMap();
    private final StringMap m_aAttributes = new StringMap();

    public Partnership(@Nonnull String string) {
        this.setName(string);
    }

    @Nonnull
    public final String getName() {
        return this.m_sName;
    }

    public final void setName(@Nonnull String string) {
        this.m_sName = (String)ValueEnforcer.notNull((Object)string, (String)"Name");
    }

    public void setSenderID(@Nonnull String string, @Nullable String string2) {
        this.m_aSenderAttrs.putIn((Object)string, (Object)string2);
    }

    public void setSenderAS2ID(@Nullable String string) {
        this.setSenderID("as2_id", string);
    }

    public void setSenderX509Alias(@Nullable String string) {
        this.setSenderID("x509_alias", string);
    }

    public void setSenderEmail(@Nullable String string) {
        this.setSenderID("email", string);
    }

    public void addSenderIDs(@Nullable Map<String, String> map) {
        this.m_aSenderAttrs.putAllIn(map);
    }

    @Nullable
    public String getSenderID(@Nullable String string) {
        return this.m_aSenderAttrs.getAsString((Object)string);
    }

    @Nullable
    public String getSenderAS2ID() {
        return this.getSenderID("as2_id");
    }

    @Nullable
    public String getSenderX509Alias() {
        return this.getSenderID("x509_alias");
    }

    @Nullable
    public String getSenderEmail() {
        return this.getSenderID("email");
    }

    public boolean containsSenderID(@Nullable String string) {
        return this.m_aSenderAttrs.containsKey((Object)string);
    }

    public boolean containsSenderAS2ID() {
        return this.containsSenderID("as2_id");
    }

    public boolean containsSenderX509Alias() {
        return this.containsSenderID("x509_alias");
    }

    public boolean containsSenderEmail() {
        return this.containsSenderID("email");
    }

    @Nonnull
    @ReturnsMutableCopy
    public IStringMap getAllSenderIDs() {
        return this.m_aSenderAttrs.getClone();
    }

    public void setReceiverID(@Nonnull String string, @Nullable String string2) {
        this.m_aReceiverAttrs.putIn((Object)string, (Object)string2);
    }

    public void setReceiverAS2ID(@Nullable String string) {
        this.setReceiverID("as2_id", string);
    }

    public void setReceiverX509Alias(@Nullable String string) {
        this.setReceiverID("x509_alias", string);
    }

    public void setReceiverEmail(@Nullable String string) {
        this.setReceiverID("email", string);
    }

    public void addReceiverIDs(@Nullable Map<String, String> map) {
        this.m_aReceiverAttrs.putAllIn(map);
    }

    @Nullable
    public String getReceiverID(@Nullable String string) {
        return this.m_aReceiverAttrs.getAsString((Object)string);
    }

    @Nullable
    public String getReceiverAS2ID() {
        return this.getReceiverID("as2_id");
    }

    @Nullable
    public String getReceiverX509Alias() {
        return this.getReceiverID("x509_alias");
    }

    @Nullable
    public String getReceiverEmail() {
        return this.getReceiverID("email");
    }

    public boolean containsReceiverID(@Nullable String string) {
        return this.m_aReceiverAttrs.containsKey((Object)string);
    }

    public boolean containsReceiverAS2ID() {
        return this.containsReceiverID("as2_id");
    }

    public boolean containsReceiverX509Alias() {
        return this.containsReceiverID("x509_alias");
    }

    public boolean containsReceiverEmail() {
        return this.containsReceiverID("email");
    }

    @Nonnull
    @ReturnsMutableCopy
    public IStringMap getAllReceiverIDs() {
        return this.m_aReceiverAttrs.getClone();
    }

    @Nonnull
    public EChange setAttribute(@Nonnull String string, @Nullable String string2) {
        if (string2 == null) {
            return this.m_aAttributes.removeObject((Object)string);
        }
        return this.m_aAttributes.putIn((Object)string, (Object)string2);
    }

    @Nullable
    public String getAttribute(@Nullable String string) {
        return this.m_aAttributes.getAsString((Object)string);
    }

    @Nullable
    public String getAttribute(@Nullable String string, @Nullable String string2) {
        return this.m_aAttributes.getAsString((Object)string, string2);
    }

    @Nullable
    public String getAS2URL() {
        return this.getAttribute("as2_url");
    }

    @Nonnull
    public EChange setAS2URL(@Nullable String string) {
        return this.setAttribute("as2_url", string);
    }

    @Nullable
    public String getAS2MDNTo() {
        return this.getAttribute("as2_mdn_to");
    }

    @Nonnull
    public EChange setAS2MDNTo(@Nullable String string) {
        return this.setAttribute("as2_mdn_to", string);
    }

    @Nullable
    public String getAS2MDNOptions() {
        return this.getAttribute("as2_mdn_options");
    }

    @Nonnull
    public EChange setAS2MDNOptions(@Nullable String string) {
        return this.setAttribute("as2_mdn_options", string);
    }

    @Nullable
    public String getAS2ReceiptDeliveryOption() {
        return this.getAttribute("as2_receipt_option");
    }

    @Nonnull
    public EChange setAS2ReceiptDeliveryOption(@Nullable String string) {
        return this.setAttribute("as2_receipt_option", string);
    }

    @Nullable
    public String getMessageIDFormat(@Nullable String string) {
        return this.getAttribute("messageid", string);
    }

    @Nonnull
    public EChange setMessageIDFormat(@Nullable String string) {
        return this.setAttribute("messageid", string);
    }

    @Nullable
    public String getMDNSubject() {
        return this.getAttribute("mdnsubject");
    }

    @Nonnull
    public EChange setMDNSubject(@Nullable String string) {
        return this.setAttribute("mdnsubject", string);
    }

    public boolean isBlockErrorMDN() {
        return this.m_aAttributes.containsKey((Object)"blockerrormdn");
    }

    @Nonnull
    public EChange setBlockErrorMDN(boolean bl) {
        return this.setAttribute("blockerrormdn", bl ? "true" : null);
    }

    @Nullable
    public String getDateFormat(@Nullable String string) {
        return this.getAttribute("mid_date_format", string);
    }

    @Nonnull
    public EChange setDateFormat(@Nullable String string) {
        return this.setAttribute("mid_date_format", string);
    }

    @Nullable
    public String getEncryptAlgorithm() {
        return this.getAttribute("encrypt");
    }

    @Nonnull
    public EChange setEncryptAlgorithm(@Nullable String string) {
        return this.setAttribute("encrypt", string);
    }

    @Nonnull
    public EChange setEncryptAlgorithm(@Nullable ECryptoAlgorithmCrypt eCryptoAlgorithmCrypt) {
        return this.setEncryptAlgorithm(eCryptoAlgorithmCrypt == null ? null : eCryptoAlgorithmCrypt.getID());
    }

    @Nullable
    public String getSigningAlgorithm() {
        return this.getAttribute("sign");
    }

    @Nonnull
    public EChange setSigningAlgorithm(@Nullable String string) {
        return this.setAttribute("sign", string);
    }

    @Nonnull
    public EChange setSigningAlgorithm(@Nullable ECryptoAlgorithmSign eCryptoAlgorithmSign) {
        return this.setSigningAlgorithm(eCryptoAlgorithmSign == null ? null : eCryptoAlgorithmSign.getID());
    }

    @Nullable
    public String getProtocol() {
        return this.getAttribute("protocol");
    }

    @Nonnull
    public EChange setProtocol(@Nullable String string) {
        return this.setAttribute("protocol", string);
    }

    @Nullable
    public String getSubject() {
        return this.getAttribute("subject");
    }

    @Nonnull
    public EChange setSubject(@Nullable String string) {
        return this.setAttribute("subject", string);
    }

    @Nullable
    public String getContentTransferEncodingSend(@Nullable String string) {
        return this.getAttribute("content_transfer_encoding", string);
    }

    @Nonnull
    public EChange setContentTransferEncodingSend(@Nullable String string) {
        return this.setAttribute("content_transfer_encoding", string);
    }

    @Nonnull
    public EChange setContentTransferEncodingSend(@Nullable EContentTransferEncoding eContentTransferEncoding) {
        return this.setContentTransferEncodingSend(eContentTransferEncoding != null ? eContentTransferEncoding.getID() : null);
    }

    @Nullable
    public String getContentTransferEncodingReceive(@Nullable String string) {
        return this.getAttribute("content_transfer_encoding_receive", string);
    }

    @Nonnull
    public EChange setContentTransferEncodingReceive(@Nullable String string) {
        return this.setAttribute("content_transfer_encoding_receive", string);
    }

    @Nonnull
    public EChange setContentTransferEncodingReceive(@Nullable EContentTransferEncoding eContentTransferEncoding) {
        return this.setContentTransferEncodingReceive(eContentTransferEncoding != null ? eContentTransferEncoding.getID() : null);
    }

    @Nullable
    public String getCompressionType() {
        return this.getAttribute("compression_type");
    }

    @Nonnull
    public EChange setCompressionType(@Nullable String string) {
        return this.setAttribute("compression_type", string);
    }

    @Nonnull
    public EChange setCompressionType(@Nullable ECompressionType eCompressionType) {
        return this.setCompressionType(eCompressionType == null ? null : eCompressionType.getID());
    }

    @Nullable
    public String getCompressionMode() {
        return this.getAttribute("compression_mode");
    }

    @Nonnull
    public EChange setCompressionMode(@Nullable String string) {
        return this.setAttribute("compression_mode", string);
    }

    public boolean isCompressBeforeSign() {
        return !"compress-after-signing".equals(this.getCompressionMode());
    }

    @Nonnull
    public EChange setCompressionModeCompressAfterSigning() {
        return this.setCompressionMode("compress-after-signing");
    }

    @Nonnull
    public EChange setCompressionModeCompressBeforeSigning() {
        return this.setCompressionMode("compress-before-signing");
    }

    public boolean isForceDecrypt() {
        return "true".equals(this.getAttribute("force_decrypt"));
    }

    @Nonnull
    public EChange setForceDecrypt(boolean bl) {
        return this.setAttribute("force_decrypt", Boolean.toString(bl));
    }

    public boolean isDisableDecrypt() {
        return "true".equals(this.getAttribute("disable_decrypt"));
    }

    @Nonnull
    public EChange setDisableDecrypt(boolean bl) {
        return this.setAttribute("disable_decrypt", Boolean.toString(bl));
    }

    public boolean isForceVerify() {
        return "true".equals(this.getAttribute("force_verify"));
    }

    @Nonnull
    public EChange setForceVerify(boolean bl) {
        return this.setAttribute("force_verify", Boolean.toString(bl));
    }

    public boolean isDisableVerify() {
        return "true".equals(this.getAttribute("disable_verify"));
    }

    @Nonnull
    public EChange setDisableVerify(boolean bl) {
        return this.setAttribute("disable_verify", Boolean.toString(bl));
    }

    @Nonnull
    private static ETriState _getAsTriState(@Nullable String string) {
        if ("true".equals(string)) {
            return ETriState.TRUE;
        }
        if ("false".equals(string)) {
            return ETriState.FALSE;
        }
        return ETriState.UNDEFINED;
    }

    @Nonnull
    public ETriState getIncludeCertificateInSignedContent() {
        String string = this.getAttribute("sign_include_cert_in_body_part");
        return Partnership._getAsTriState(string);
    }

    @Nonnull
    public EChange setIncludeCertificateInSignedContent(@Nonnull ETriState eTriState) {
        return this.setAttribute("sign_include_cert_in_body_part", eTriState.isUndefined() ? null : Boolean.toString(eTriState.getAsBooleanValue()));
    }

    @Nonnull
    public ETriState getVerifyUseCertificateInBodyPart() {
        String string = this.getAttribute("verify_use_cert_in_body_part");
        return Partnership._getAsTriState(string);
    }

    @Nonnull
    public EChange setVerifyUseCertificateInBodyPart(@Nonnull ETriState eTriState) {
        return this.setAttribute("verify_use_cert_in_body_part", eTriState.isUndefined() ? null : Boolean.toString(eTriState.getAsBooleanValue()));
    }

    public boolean isDisableDecompress() {
        return "true".equals(this.getAttribute("disable_decompress"));
    }

    @Nonnull
    public EChange setDisableDecompress(boolean bl) {
        return this.setAttribute("disable_decompress", Boolean.toString(bl));
    }

    public boolean isRFC3851MICAlgs() {
        return this.m_aAttributes.getAsBoolean((Object)"rfc3851_micalgs", false);
    }

    @Nonnull
    public EChange setRFC3851MICAlgs(boolean bl) {
        return this.setAttribute("rfc3851_micalgs", Boolean.toString(bl));
    }

    public boolean isRemoveCmsAlgorithmProtect() {
        return this.m_aAttributes.getAsBoolean((Object)"remove_cms_algorithm_protect_attr", false);
    }

    @Nonnull
    public EChange setRemoveCmsAlgorithmProtect(boolean bl) {
        return this.setAttribute("remove_cms_algorithm_protect_attr", Boolean.toString(bl));
    }

    @Nonnull
    @ReturnsMutableCopy
    public IStringMap getAllAttributes() {
        return this.m_aAttributes.getClone();
    }

    public void addAllAttributes(@Nullable Map<String, String> map) {
        this.m_aAttributes.putAllIn(map);
    }

    public boolean matches(@Nonnull Partnership partnership) {
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        return this.compareIDs((IStringMap)this.m_aSenderAttrs, (IStringMap)partnership.m_aSenderAttrs) && this.compareIDs((IStringMap)this.m_aReceiverAttrs, (IStringMap)partnership.m_aReceiverAttrs);
    }

    protected boolean compareIDs(@Nonnull IStringMap iStringMap, @Nonnull IStringMap iStringMap2) {
        if (iStringMap.isEmpty()) {
            return false;
        }
        for (Map.Entry entry : iStringMap.entrySet()) {
            String string;
            String string2 = (String)entry.getValue();
            if (EqualsHelper.equals((Object)string2, (Object)(string = iStringMap2.getAsString(entry.getKey())))) continue;
            return false;
        }
        return true;
    }

    public void copyFrom(@Nonnull Partnership partnership) {
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        if (partnership != this) {
            this.m_sName = partnership.getName();
            this.m_aSenderAttrs.putAllIn((Map)partnership.m_aSenderAttrs);
            this.m_aReceiverAttrs.putAllIn((Map)partnership.m_aReceiverAttrs);
            this.m_aAttributes.putAllIn((Map)partnership.m_aAttributes);
        }
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("name", (Object)this.m_sName).append("senderIDs", (Object)this.m_aSenderAttrs).append("receiverIDs", (Object)this.m_aReceiverAttrs).append("attributes", (Object)this.m_aAttributes).getToString();
    }

    @Nonnull
    public static Partnership createPlaceholderPartnership() {
        return new Partnership(DEFAULT_NAME);
    }
}

