/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.message;

import com.helger.as2lib.partner.Partnership;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.IStringMap;
import com.helger.commons.http.HttpHeaderMap;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IBaseMessage
extends Serializable {
    @Nonnull
    @ReturnsMutableObject
    public IStringMap attrs();

    @Nonnull
    @ReturnsMutableObject
    public HttpHeaderMap headers();

    @Nullable
    default public String getHeader(@Nonnull String string) {
        return this.getHeaderCombined(string, ", ");
    }

    @Nullable
    default public String getHeaderCombined(@Nonnull String string, @Nonnull String string2) {
        return this.headers().getHeaderCombined(string, string2);
    }

    @Nullable
    default public String getHeaderOrDefault(@Nonnull String string, @Nullable String string2) {
        String string3 = this.getHeader(string);
        return string3 != null ? string3 : string2;
    }

    default public boolean containsHeader(@Nullable String string) {
        return this.headers().containsHeaders(string);
    }

    @Nullable
    default public String getMessageID() {
        return this.getHeader("Message-ID");
    }

    default public void setMessageID(@Nullable String string) {
        this.headers().setHeader("Message-ID", string);
    }

    @Nonnull
    public String generateMessageID();

    default public void updateMessageID() {
        this.setMessageID(this.generateMessageID());
    }

    @Nonnull
    @ReturnsMutableObject
    public Partnership partnership();

    public void setPartnership(@Nonnull Partnership var1);

    @Nonnull
    @Nonempty
    public String getLoggingText();

    @Nonnull
    @Nonempty
    public String getAsString();
}

