/*
 * Decompiled with CFR 0.152.
 */
package com.helger.as2lib.message;

import com.helger.as2lib.message.IBaseMessage;
import com.helger.as2lib.partner.Partnership;
import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.attr.StringMap;
import com.helger.commons.http.HttpHeaderMap;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;

public abstract class AbstractBaseMessage
implements IBaseMessage {
    private StringMap m_aAttributes = new StringMap();
    private HttpHeaderMap m_aHeaders = new HttpHeaderMap();
    private Partnership m_aPartnership = Partnership.createPlaceholderPartnership();

    private void readObject(@Nonnull ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.m_aAttributes = (StringMap)objectInputStream.readObject();
        this.m_aHeaders = (HttpHeaderMap)objectInputStream.readObject();
        this.m_aPartnership = (Partnership)objectInputStream.readObject();
    }

    private void writeObject(@Nonnull ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.m_aAttributes);
        objectOutputStream.writeObject(this.m_aHeaders);
        objectOutputStream.writeObject(this.m_aPartnership);
    }

    @Nonnull
    @ReturnsMutableObject
    public final StringMap attrs() {
        return this.m_aAttributes;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final HttpHeaderMap headers() {
        return this.m_aHeaders;
    }

    @Override
    public final void setPartnership(@Nonnull Partnership partnership) {
        ValueEnforcer.notNull((Object)partnership, (String)"Partnership");
        this.m_aPartnership = partnership;
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final Partnership partnership() {
        return this.m_aPartnership;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getLoggingText() {
        String string = this.getMessageID();
        return " [" + (string == null ? "no message ID set" : string) + "]";
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("attributes", (Object)this.m_aAttributes).append("headers", (Object)this.m_aHeaders).append("partnership", (Object)this.m_aPartnership).getToString();
    }
}

