/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.support;

import com.hazelcast.core.HazelcastInstance;
import java.lang.reflect.Method;
import org.springframework.data.hazelcast.repository.query.HazelcastPartTreeQuery;
import org.springframework.data.hazelcast.repository.support.HazelcastQueryMethod;
import org.springframework.data.hazelcast.repository.support.StringBasedHazelcastRepositoryQuery;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.util.Assert;

public class HazelcastQueryLookupStrategy
implements QueryLookupStrategy {
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final KeyValueOperations keyValueOperations;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private final HazelcastInstance hazelcastInstance;

    public HazelcastQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, HazelcastInstance hazelcastInstance) {
        Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
        Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null!");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        Assert.notNull((Object)hazelcastInstance, (String)"HazelcastInstance must not be null!");
        this.evaluationContextProvider = evaluationContextProvider;
        this.keyValueOperations = keyValueOperations;
        this.queryCreator = queryCreator;
        this.hazelcastInstance = hazelcastInstance;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        HazelcastQueryMethod queryMethod = new HazelcastQueryMethod(method, metadata, projectionFactory);
        if (queryMethod.hasAnnotatedQuery()) {
            return new StringBasedHazelcastRepositoryQuery(queryMethod, this.hazelcastInstance);
        }
        return new HazelcastPartTreeQuery(queryMethod, this.evaluationContextProvider, this.keyValueOperations, this.queryCreator);
    }
}

