/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.query;

import java.util.Comparator;
import java.util.Map;
import org.springframework.data.domain.Sort;
import org.springframework.data.hazelcast.repository.query.HazelcastPropertyComparator;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;

public class HazelcastSortAccessor
implements SortAccessor<Comparator<Map.Entry<?, ?>>> {
    public Comparator<Map.Entry<?, ?>> resolve(KeyValueQuery<?> query) {
        if (query == null || query.getSort() == Sort.unsorted()) {
            return null;
        }
        Comparator<Map.Entry<?, ?>> hazelcastPropertyComparator = null;
        for (Sort.Order order : query.getSort()) {
            if (order.getProperty().indexOf(46) > -1) {
                throw new UnsupportedOperationException("Embedded fields not implemented: " + order);
            }
            if (order.isIgnoreCase()) {
                throw new UnsupportedOperationException("Ignore case not implemented: " + order);
            }
            if (Sort.NullHandling.NATIVE != order.getNullHandling()) {
                throw new UnsupportedOperationException("Null handling not implemented: " + order);
            }
            if (hazelcastPropertyComparator == null) {
                hazelcastPropertyComparator = new HazelcastPropertyComparator(order.getProperty(), order.isAscending());
                continue;
            }
            hazelcastPropertyComparator = hazelcastPropertyComparator.thenComparing(new HazelcastPropertyComparator(order.getProperty(), order.isAscending()));
        }
        return hazelcastPropertyComparator;
    }
}

