/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast;

import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.springframework.data.hazelcast.HazelcastKeyValueAdapter;
import org.springframework.data.hazelcast.repository.query.HazelcastCriteriaAccessor;
import org.springframework.data.hazelcast.repository.query.HazelcastSortAccessor;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.util.Assert;

public class HazelcastQueryEngine
extends QueryEngine<HazelcastKeyValueAdapter, Predicate<?, ?>, Comparator<Map.Entry<?, ?>>> {
    public HazelcastQueryEngine() {
        super((CriteriaAccessor)new HazelcastCriteriaAccessor(), (SortAccessor)new HazelcastSortAccessor());
    }

    public Collection<?> execute(Predicate<?, ?> criteria, Comparator<Map.Entry<?, ?>> sort, long offset, int rows, String keyspace) {
        HazelcastKeyValueAdapter adapter = (HazelcastKeyValueAdapter)this.getAdapter();
        Assert.notNull((Object)((Object)adapter), (String)"Adapter must not be 'null'.");
        PagingPredicate predicateToUse = criteria;
        Comparator<Map.Entry<?, ?>> sortToUse = sort;
        if (rows > 0) {
            PagingPredicate pp = new PagingPredicate(predicateToUse, sortToUse, rows);
            for (long x = offset / (long)rows; x > 0L; --x) {
                pp.nextPage();
            }
            predicateToUse = pp;
        } else if (sortToUse != null) {
            predicateToUse = new PagingPredicate(predicateToUse, sortToUse, Integer.MAX_VALUE);
        }
        if (predicateToUse == null) {
            return adapter.getMap(keyspace).values();
        }
        return adapter.getMap(keyspace).values((Predicate)predicateToUse);
    }

    public long count(Predicate<?, ?> criteria, String keyspace) {
        HazelcastKeyValueAdapter adapter = (HazelcastKeyValueAdapter)this.getAdapter();
        Assert.notNull((Object)((Object)adapter), (String)"Adapter must not be 'null'.");
        return adapter.getMap(keyspace).keySet(criteria).size();
    }
}

