/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.data.hazelcast.HazelcastQueryEngine;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.ForwardingCloseableIterator;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;

public class HazelcastKeyValueAdapter
extends AbstractKeyValueAdapter {
    private HazelcastInstance hzInstance;

    public HazelcastKeyValueAdapter(HazelcastInstance hzInstance) {
        super((QueryEngine)new HazelcastQueryEngine());
        Assert.notNull((Object)hzInstance, (String)"hzInstance must not be 'null'.");
        this.hzInstance = hzInstance;
    }

    public void setHzInstance(HazelcastInstance hzInstance) {
        this.hzInstance = hzInstance;
    }

    public Object put(Object id, Object item, String keyspace) {
        Assert.notNull((Object)id, (String)"Id must not be 'null' for adding.");
        Assert.notNull((Object)item, (String)"Item must not be 'null' for adding.");
        return this.getMap(keyspace).put(id, item);
    }

    public boolean contains(Object id, String keyspace) {
        return this.getMap(keyspace).containsKey(id);
    }

    public Object get(Object id, String keyspace) {
        return this.getMap(keyspace).get(id);
    }

    public Object delete(Object id, String keyspace) {
        return this.getMap(keyspace).remove(id);
    }

    public Iterable<?> getAllOf(String keyspace) {
        return this.getMap(keyspace).values();
    }

    public void deleteAllOf(String keyspace) {
        this.getMap(keyspace).clear();
    }

    public void clear() {
        this.hzInstance.shutdown();
    }

    protected IMap<Object, Object> getMap(String keyspace) {
        return this.hzInstance.getMap(keyspace);
    }

    public void destroy() {
        this.clear();
    }

    public long count(String keyspace) {
        return this.getMap(keyspace).size();
    }

    public CloseableIterator<Map.Entry<Object, Object>> entries(String keyspace) {
        Iterator iterator = this.getMap(keyspace).entrySet().iterator();
        return new ForwardingCloseableIterator(iterator);
    }
}

