/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.support;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.SqlPredicate;
import org.springframework.data.hazelcast.repository.support.HazelcastQueryMethod;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;

public class StringBasedHazelcastRepositoryQuery
implements RepositoryQuery {
    private final HazelcastQueryMethod queryMethod;
    private final String keySpace;
    private final HazelcastInstance hazelcastInstance;

    public StringBasedHazelcastRepositoryQuery(HazelcastQueryMethod queryMethod, HazelcastInstance hazelcastInstance) {
        this.queryMethod = queryMethod;
        this.keySpace = queryMethod.getKeySpace();
        this.hazelcastInstance = hazelcastInstance;
    }

    public Object execute(Object[] parameters) {
        String queryStringTemplate = this.queryMethod.getAnnotatedQuery();
        String queryString = String.format(queryStringTemplate, parameters);
        SqlPredicate sqlPredicate = new SqlPredicate(queryString);
        return this.getMap(this.keySpace).values((Predicate)sqlPredicate);
    }

    private IMap getMap(String keySpace) {
        return this.hazelcastInstance.getMap(keySpace);
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }
}

