/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.support;

import com.hazelcast.core.HazelcastInstance;
import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.hazelcast.repository.support.HazelcastRepositoryFactory;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactory;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactoryBean;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.util.Assert;

public class HazelcastRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends KeyValueRepositoryFactoryBean<T, S, ID> {
    @Autowired(required=false)
    private HazelcastInstance hazelcastInstance;

    public HazelcastRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    protected KeyValueRepositoryFactory createRepositoryFactory(KeyValueOperations operations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, Class<? extends RepositoryQuery> repositoryQueryType) {
        Assert.state((this.hazelcastInstance != null ? 1 : 0) != 0, (String)"HazelcastInstance must be set");
        return new HazelcastRepositoryFactory(operations, queryCreator, this.hazelcastInstance);
    }
}

