/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hazelcast.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

public class HazelcastPartTreeQuery
extends KeyValuePartTreeQuery {
    private final QueryMethod queryMethod;
    private final KeyValueOperations keyValueOperations;
    private boolean isCount;
    private boolean isDelete;
    private boolean isDistinct;
    private boolean isRearrangeKnown;
    private boolean isRearrangeRequired;
    private int[] rearrangeIndex;

    public HazelcastPartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evaluationContextProvider, keyValueOperations, queryCreator);
        this.queryMethod = queryMethod;
        this.keyValueOperations = keyValueOperations;
        this.isRearrangeKnown = false;
    }

    public Object execute(Object[] parameters) {
        KeyValueQuery<?> query = this.prepareQuery(parameters);
        if (this.isDistinct) {
            String message = String.format("DISTINCT modifier in '%s' not applicable to Key-Value queries.", this.queryMethod.getName());
            throw new UnsupportedOperationException(message);
        }
        if (this.isCount) {
            return this.keyValueOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (this.isDelete) {
            return this.executeDeleteQuery(query, this.queryMethod);
        }
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            return this.executePageSliceQuery(parameters, query, this.queryMethod);
        }
        if (this.queryMethod.isCollectionQuery() || this.queryMethod.isQueryForEntity() || this.queryMethod.isStreamQuery()) {
            return this.executeFindQuery(query, this.queryMethod);
        }
        String message = String.format("Query method '%s' not supported.", this.queryMethod.getName());
        throw new UnsupportedOperationException(message);
    }

    private Object executeDeleteQuery(KeyValueQuery<?> query, QueryMethod queryMethod) {
        Iterable resultSet = this.keyValueOperations.find(query, queryMethod.getEntityInformation().getJavaType());
        Iterator iterator = resultSet.iterator();
        ArrayList<Object> result = new ArrayList<Object>();
        while (iterator.hasNext()) {
            result.add(this.keyValueOperations.delete(iterator.next()));
        }
        if (queryMethod.isCollectionQuery()) {
            return result;
        }
        if (Long.TYPE.equals(queryMethod.getReturnedObjectType()) || Long.class.equals((Object)queryMethod.getReturnedObjectType())) {
            return result.size();
        }
        throw new UnsupportedOperationException(String.format("Illegal returned type: %s. The operation 'deleteBy' accepts only 'long' and 'Collection' as the returned object type", queryMethod.getReturnedObjectType()));
    }

    private Object executeFindQuery(KeyValueQuery<?> query, QueryMethod queryMethod) {
        Iterable resultSet = this.keyValueOperations.find(query, queryMethod.getEntityInformation().getJavaType());
        if (!(queryMethod.isCollectionQuery() || queryMethod.isPageQuery() || queryMethod.isSliceQuery() || queryMethod.isStreamQuery())) {
            return resultSet.iterator().hasNext() ? resultSet.iterator().next() : null;
        }
        if (queryMethod.isStreamQuery()) {
            return StreamUtils.createStreamFromIterator(resultSet.iterator());
        }
        return resultSet;
    }

    private Object executePageSliceQuery(Object[] parameters, KeyValueQuery<?> query, QueryMethod queryMethod) {
        boolean hasNext;
        long totalElements = -1L;
        int indexOfPageRequest = queryMethod.getParameters().getPageableIndex();
        Pageable pageRequest = (Pageable)parameters[indexOfPageRequest];
        totalElements = query.getCriteria() == null ? this.keyValueOperations.count(queryMethod.getEntityInformation().getJavaType()) : this.keyValueOperations.count(query, queryMethod.getEntityInformation().getJavaType());
        int requiredRows = pageRequest.getPageSize();
        query.setOffset(pageRequest.getOffset());
        query.setRows(pageRequest.getPageSize());
        Iterable resultSet = this.keyValueOperations.find(query, queryMethod.getEntityInformation().getJavaType());
        List content = IterableConverter.toList((Iterable)resultSet);
        if (queryMethod.isPageQuery()) {
            return new PageImpl(content, pageRequest, totalElements);
        }
        boolean bl = hasNext = totalElements > query.getOffset() + (long)query.getRows();
        if (content.size() > requiredRows) {
            content = content.subList(0, requiredRows);
        }
        return new SliceImpl(content, pageRequest, hasNext);
    }

    protected KeyValueQuery<?> prepareQuery(Object[] parameters) {
        PartTree tree = null;
        if (this.queryMethod.getParameters().getNumberOfParameters() > 0) {
            tree = new PartTree(this.getQueryMethod().getName(), this.getQueryMethod().getEntityInformation().getJavaType());
            this.isCount = tree.isCountProjection();
            this.isDelete = tree.isDelete();
            this.isDistinct = tree.isDistinct();
        } else {
            this.isCount = false;
            this.isDelete = false;
            this.isDistinct = false;
        }
        ParametersParameterAccessor accessor = this.prepareAccessor(parameters, tree);
        KeyValueQuery query = this.createQuery((ParameterAccessor)accessor);
        if (accessor.getPageable() != Pageable.unpaged()) {
            query.setOffset(accessor.getPageable().getOffset());
            query.setRows(accessor.getPageable().getPageSize());
        } else {
            query.setOffset(-1L);
            query.setRows(-1);
        }
        if (accessor.getSort() != Sort.unsorted()) {
            query.setSort(accessor.getSort());
        }
        return query;
    }

    private ParametersParameterAccessor prepareAccessor(Object[] originalParameters, PartTree partTree) {
        if (!this.isRearrangeKnown) {
            this.prepareRearrange(partTree, this.queryMethod.getParameters().getBindableParameters());
            this.isRearrangeKnown = true;
        }
        Object[] parameters = originalParameters;
        Assert.notNull((Object)parameters, (String)"Parameters must not be null.");
        if (this.isRearrangeRequired) {
            parameters = new Object[originalParameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                int index = this.rearrangeIndex[i];
                parameters[i] = originalParameters[index];
            }
        }
        return new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
    }

    private void prepareRearrange(PartTree partTree, Parameters<?, ?> bindableParameters) {
        this.isRearrangeRequired = false;
        if (partTree == null || bindableParameters == null) {
            return;
        }
        ArrayList<String> queryParams = new ArrayList<String>();
        ArrayList methodParams = new ArrayList();
        for (Part part : partTree.getParts()) {
            queryParams.add(part.getProperty().getSegment());
        }
        for (Parameter parameter : bindableParameters) {
            parameter.getName().ifPresent(methodParams::add);
        }
        this.rearrangeIndex = new int[queryParams.size()];
        String[] paramsExpected = queryParams.toArray(new String[queryParams.size()]);
        String[] paramsProvided = methodParams.toArray(new String[methodParams.size()]);
        for (int i = 0; i < this.rearrangeIndex.length; ++i) {
            this.rearrangeIndex[i] = i;
            for (int j = 0; j < paramsProvided.length; ++j) {
                if (paramsProvided[j] == null || !paramsProvided[j].equals(paramsExpected[i])) continue;
                this.rearrangeIndex[i] = j;
                this.isRearrangeRequired = true;
            }
        }
    }
}

