/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.topic.impl;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.LocalTopicStats;
import com.hazelcast.topic.MessageListener;
import com.hazelcast.topic.impl.TopicProxySupport;
import com.hazelcast.topic.impl.TopicService;
import java.util.UUID;
import javax.annotation.Nonnull;

public class TopicProxy<E>
extends TopicProxySupport
implements ITopic<E> {
    protected static final String NULL_MESSAGE_IS_NOT_ALLOWED = "Null message is not allowed!";
    protected static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";

    public TopicProxy(String name, NodeEngine nodeEngine, TopicService service) {
        super(name, nodeEngine, service);
    }

    @Override
    public void publish(@Nonnull E message) {
        Preconditions.checkNotNull(message, NULL_MESSAGE_IS_NOT_ALLOWED);
        this.publishInternal(message);
    }

    @Override
    @Nonnull
    public UUID addMessageListener(@Nonnull MessageListener<E> listener) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        return this.addMessageListenerInternal(listener);
    }

    @Override
    public boolean removeMessageListener(@Nonnull UUID registrationId) {
        return this.removeMessageListenerInternal(registrationId);
    }

    @Override
    @Nonnull
    public LocalTopicStats getLocalTopicStats() {
        return this.getLocalTopicStatsInternal();
    }
}

