/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.record.DataRecord;
import com.hazelcast.map.impl.record.DataRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;

public enum RecordReaderWriter {
    DATA_RECORD_READER_WRITER(1){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getRawTtl());
            out.writeInt(record.getRawMaxIdle());
            out.writeInt(record.getRawCreationTime());
            out.writeInt(record.getRawLastAccessTime());
            out.writeInt(record.getRawLastUpdateTime());
            out.writeInt(record.getHits());
            out.writeLong(record.getVersion());
        }

        @Override
        Record readRecord(ObjectDataInput in) throws IOException {
            DataRecord record = new DataRecord();
            record.setValue(IOUtil.readData(in));
            record.setRawTtl(in.readInt());
            record.setRawMaxIdle(in.readInt());
            record.setRawCreationTime(in.readInt());
            record.setRawLastAccessTime(in.readInt());
            record.setRawLastUpdateTime(in.readInt());
            record.setHits(in.readInt());
            record.setVersion(in.readLong());
            return record;
        }
    }
    ,
    DATA_RECORD_WITH_STATS_READER_WRITER(2){

        @Override
        void writeRecord(ObjectDataOutput out, Record record, Data dataValue) throws IOException {
            IOUtil.writeData(out, dataValue);
            out.writeInt(record.getRawTtl());
            out.writeInt(record.getRawMaxIdle());
            out.writeInt(record.getRawCreationTime());
            out.writeInt(record.getRawLastAccessTime());
            out.writeInt(record.getRawLastUpdateTime());
            out.writeInt(record.getHits());
            out.writeLong(record.getVersion());
            out.writeInt(record.getRawLastStoredTime());
            out.writeInt(record.getRawExpirationTime());
        }

        @Override
        Record readRecord(ObjectDataInput in) throws IOException {
            DataRecordWithStats record = new DataRecordWithStats();
            record.setValue(IOUtil.readData(in));
            record.setRawTtl(in.readInt());
            record.setRawMaxIdle(in.readInt());
            record.setRawCreationTime(in.readInt());
            record.setRawLastAccessTime(in.readInt());
            record.setRawLastUpdateTime(in.readInt());
            record.setHits(in.readInt());
            record.setVersion(in.readLong());
            record.setRawLastStoredTime(in.readInt());
            record.setRawExpirationTime(in.readInt());
            return record;
        }
    };

    private byte id;

    private RecordReaderWriter(byte id) {
        this.id = id;
    }

    public byte getId() {
        return this.id;
    }

    public static RecordReaderWriter getById(int id) {
        switch (id) {
            case 1: {
                return DATA_RECORD_READER_WRITER;
            }
            case 2: {
                return DATA_RECORD_WITH_STATS_READER_WRITER;
            }
        }
        throw new IllegalArgumentException();
    }

    abstract void writeRecord(ObjectDataOutput var1, Record var2, Data var3) throws IOException;

    abstract Record readRecord(ObjectDataInput var1) throws IOException;

    private static class TypeId {
        private static final byte DATA_RECORD_TYPE_ID = 1;
        private static final byte DATA_RECORD_WITH_STATS_TYPE_ID = 2;

        private TypeId() {
        }
    }
}

