/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.record.CachedDataRecord;
import com.hazelcast.map.impl.record.CachedDataRecordWithStats;
import com.hazelcast.map.impl.record.DataRecord;
import com.hazelcast.map.impl.record.DataRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;

public class DataRecordFactory
implements RecordFactory<Data> {
    private final boolean statisticsEnabled;
    private final SerializationService ss;
    private final CacheDeserializedValues cacheDeserializedValues;

    public DataRecordFactory(MapConfig config, SerializationService ss) {
        this.ss = ss;
        this.statisticsEnabled = config.isStatisticsEnabled();
        this.cacheDeserializedValues = config.getCacheDeserializedValues();
    }

    @Override
    public Record<Data> newRecord(Object value) {
        Object valueData = this.ss.toData(value);
        switch (this.cacheDeserializedValues) {
            case NEVER: {
                return this.statisticsEnabled ? new DataRecordWithStats((Data)valueData) : new DataRecord((Data)valueData);
            }
        }
        return this.statisticsEnabled ? new CachedDataRecordWithStats((Data)valueData) : new CachedDataRecord((Data)valueData);
    }
}

