/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.util.collection.InflatableSet;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.map.impl.wan.WanMapEntryView;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class MerkleTreeNodeEntries
implements IdentifiedDataSerializable {
    private int nodeOrder;
    private Set<WanMapEntryView<Object, Object>> nodeEntries = Collections.emptySet();

    public MerkleTreeNodeEntries() {
    }

    public MerkleTreeNodeEntries(int nodeOrder, Set<WanMapEntryView<Object, Object>> nodeEntries) {
        this.nodeOrder = nodeOrder;
        this.nodeEntries = nodeEntries;
    }

    public Set<WanMapEntryView<Object, Object>> getNodeEntries() {
        return this.nodeEntries;
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 139;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.nodeOrder);
        out.writeInt(this.nodeEntries.size());
        for (WanMapEntryView<Object, Object> entryView : this.nodeEntries) {
            out.writeObject(entryView);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.nodeOrder = in.readInt();
        int entryCount = in.readInt();
        InflatableSet.Builder entries = InflatableSet.newBuilder(entryCount);
        for (int j = 0; j < entryCount; ++j) {
            entries.add(in.readObject());
        }
        this.nodeEntries = entries.build();
    }
}

