/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.pipeline;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.processor.SourceProcessors;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.Sources;
import com.hazelcast.jet.pipeline.StreamSource;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;

public final class JmsSourceBuilder {
    private final SupplierEx<? extends ConnectionFactory> factorySupplier;
    private final boolean isTopic;
    private FunctionEx<? super ConnectionFactory, ? extends Connection> connectionFn;
    private FunctionEx<? super Session, ? extends MessageConsumer> consumerFn;
    private FunctionEx<? super Message, ?> messageIdFn = Message::getJMSMessageID;
    private String username;
    private String password;
    private String destinationName;
    private ProcessingGuarantee maxGuarantee = ProcessingGuarantee.EXACTLY_ONCE;
    private boolean isSharedConsumer;

    JmsSourceBuilder(@Nonnull SupplierEx<? extends ConnectionFactory> factorySupplier, boolean isTopic) {
        Util.checkSerializable(factorySupplier, "factorySupplier");
        this.factorySupplier = Preconditions.checkNotNull(factorySupplier);
        this.isTopic = isTopic;
    }

    @Nonnull
    public JmsSourceBuilder connectionParams(@Nullable String username, @Nullable String password) {
        this.username = username;
        this.password = password;
        return this;
    }

    @Nonnull
    public JmsSourceBuilder connectionFn(@Nullable FunctionEx<? super ConnectionFactory, ? extends Connection> connectionFn) {
        Util.checkSerializable(connectionFn, "connectionFn");
        this.connectionFn = connectionFn;
        return this;
    }

    @Nonnull
    public JmsSourceBuilder destinationName(@Nullable String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    @Nonnull
    public JmsSourceBuilder consumerFn(@Nullable FunctionEx<? super Session, ? extends MessageConsumer> consumerFn) {
        Util.checkSerializable(consumerFn, "consumerFn");
        this.consumerFn = consumerFn;
        return this;
    }

    @Nonnull
    public JmsSourceBuilder messageIdFn(@Nonnull FunctionEx<? super Message, ?> messageIdFn) {
        this.messageIdFn = Preconditions.checkNotNull(messageIdFn);
        return this;
    }

    @Nonnull
    public JmsSourceBuilder maxGuarantee(@Nonnull ProcessingGuarantee guarantee) {
        this.maxGuarantee = Preconditions.checkNotNull(guarantee);
        return this;
    }

    @Nonnull
    public JmsSourceBuilder sharedConsumer(boolean isSharedConsumer) {
        this.isSharedConsumer = isSharedConsumer;
        return this;
    }

    @Nonnull
    public <T> StreamSource<T> build(@Nonnull FunctionEx<? super Message, ? extends T> projectionFn) {
        String usernameLocal = this.username;
        String passwordLocal = this.password;
        String destinationLocal = this.destinationName;
        ProcessingGuarantee maxGuaranteeLocal = this.maxGuarantee;
        boolean isTopicLocal = this.isTopic;
        if (this.connectionFn == null) {
            this.connectionFn = factory -> Objects.requireNonNull(usernameLocal != null || passwordLocal != null ? factory.createConnection(usernameLocal, passwordLocal) : factory.createConnection());
        }
        if (this.consumerFn == null) {
            Preconditions.checkNotNull(destinationLocal, "neither consumerFn nor destinationName set");
            this.consumerFn = session -> session.createConsumer((Destination)(isTopicLocal ? session.createTopic(destinationLocal) : session.createQueue(destinationLocal)));
            if (this.isTopic) {
                maxGuaranteeLocal = ProcessingGuarantee.NONE;
            }
        }
        ProcessingGuarantee maxGuaranteeFinal = maxGuaranteeLocal;
        FunctionEx<? super ConnectionFactory, ? extends Connection> connectionFnLocal = this.connectionFn;
        SupplierEx<? extends ConnectionFactory> factorySupplierLocal = this.factorySupplier;
        SupplierEx<Connection> newConnectionFn = () -> (Connection)connectionFnLocal.apply((ConnectionFactory)factorySupplierLocal.get());
        Function metaSupplierFactory = policy -> this.isTopic ? SourceProcessors.streamJmsTopicP(newConnectionFn, this.consumerFn, this.isSharedConsumer, this.messageIdFn, projectionFn, policy, maxGuaranteeFinal) : SourceProcessors.streamJmsQueueP(newConnectionFn, this.consumerFn, this.messageIdFn, projectionFn, policy, maxGuaranteeFinal);
        return Sources.streamFromProcessorWithWatermarks(this.sourceName(), true, metaSupplierFactory);
    }

    @Nonnull
    public StreamSource<Message> build() {
        return this.build(message -> message);
    }

    private String sourceName() {
        return (this.isTopic ? "jmsTopicSource(" : "jmsQueueSource(") + (this.destinationName == null ? "?" : this.destinationName) + ')';
    }
}

