/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.pipeline;

import com.hazelcast.jet.aggregate.AggregateOperation;
import com.hazelcast.jet.datamodel.Tag;
import com.hazelcast.jet.impl.pipeline.AbstractStage;
import com.hazelcast.jet.impl.pipeline.ComputeStageImplBase;
import com.hazelcast.jet.impl.pipeline.FunctionAdapter;
import com.hazelcast.jet.impl.pipeline.PipelineImpl;
import com.hazelcast.jet.impl.pipeline.transform.AbstractTransform;
import com.hazelcast.jet.impl.pipeline.transform.AggregateTransform;
import com.hazelcast.jet.impl.pipeline.transform.Transform;
import com.hazelcast.jet.impl.pipeline.transform.WindowAggregateTransform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.GeneralStage;
import com.hazelcast.jet.pipeline.WindowDefinition;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AggBuilder {
    @Nullable
    private final WindowDefinition wDef;
    @Nonnull
    private final PipelineImpl pipelineImpl;
    @Nonnull
    private final List<GeneralStage> upstreamStages = new ArrayList<GeneralStage>();

    public <T0> AggBuilder(@Nonnull GeneralStage<T0> stage0, @Nullable WindowDefinition wDef) {
        this.wDef = wDef;
        this.pipelineImpl = ((AbstractStage)((Object)stage0)).pipelineImpl;
        this.add(stage0);
    }

    @Nonnull
    public <E> Tag<E> add(@Nonnull GeneralStage<E> stage) {
        if (this.wDef != null) {
            ComputeStageImplBase.ensureJetEvents((ComputeStageImplBase)((Object)stage), "This pipeline stage");
        }
        this.upstreamStages.add(stage);
        return Tag.tag(this.upstreamStages.size() - 1);
    }

    @Nonnull
    public <A, R, OUT, OUT_STAGE extends GeneralStage<OUT>> OUT_STAGE build(@Nonnull AggregateOperation<A, R> aggrOp, @Nonnull CreateOutStageFn<OUT, OUT_STAGE> createOutStageFn) {
        AggregateOperation<A, R> adaptedAggrOp = this.wDef != null ? ComputeStageImplBase.ADAPT_TO_JET_EVENT.adaptAggregateOperation(aggrOp) : aggrOp;
        List<Transform> upstreamTransforms = Util.toList(this.upstreamStages, s -> ((AbstractStage)((Object)s)).transform);
        AbstractTransform transform = this.wDef != null ? new WindowAggregateTransform<A, R>(upstreamTransforms, this.wDef, adaptedAggrOp) : new AggregateTransform<A, R>(upstreamTransforms, adaptedAggrOp);
        OUT_STAGE attached = createOutStageFn.get(transform, ComputeStageImplBase.ADAPT_TO_JET_EVENT, this.pipelineImpl);
        this.pipelineImpl.connectGeneralStages(this.upstreamStages, transform);
        return attached;
    }

    @FunctionalInterface
    public static interface CreateOutStageFn<OUT, OUT_STAGE extends GeneralStage<OUT>> {
        public OUT_STAGE get(Transform var1, FunctionAdapter var2, PipelineImpl var3);
    }
}

