/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PhoneHome {
    private static final int TIMEOUT = 1000;
    private static final int A_INTERVAL = 5;
    private static final int B_INTERVAL = 10;
    private static final int C_INTERVAL = 20;
    private static final int D_INTERVAL = 40;
    private static final int E_INTERVAL = 60;
    private static final int F_INTERVAL = 100;
    private static final int G_INTERVAL = 150;
    private static final int H_INTERVAL = 300;
    private static final int J_INTERVAL = 600;
    private static final String BASE_PHONE_HOME_URL = "http://phonehome.hazelcast.com/ping";
    private static final int CONNECTION_TIMEOUT_MILLIS = 3000;
    private static final String FALSE = "false";
    volatile ScheduledFuture<?> phoneHomeFuture;
    private final ILogger logger;
    private final BuildInfo buildInfo = BuildInfoProvider.getBuildInfo();

    public PhoneHome(Node hazelcastNode) {
        this.logger = hazelcastNode.getLogger(PhoneHome.class);
    }

    public void check(Node hazelcastNode) {
        if (!hazelcastNode.getProperties().getBoolean(ClusterProperty.PHONE_HOME_ENABLED)) {
            return;
        }
        if (FALSE.equals(System.getenv("HZ_PHONE_HOME_ENABLED"))) {
            return;
        }
        try {
            this.phoneHomeFuture = hazelcastNode.nodeEngine.getExecutionService().scheduleWithRepetition("PhoneHome", () -> this.phoneHome(hazelcastNode, false), 0L, 1L, TimeUnit.DAYS);
        }
        catch (RejectedExecutionException e) {
            this.logger.warning("Could not schedule phone home task! Most probably Hazelcast failed to start.");
        }
    }

    public void shutdown() {
        if (this.phoneHomeFuture != null) {
            this.phoneHomeFuture.cancel(true);
        }
    }

    public String convertToLetter(int size) {
        String letter = size < 5 ? "A" : (size < 10 ? "B" : (size < 20 ? "C" : (size < 40 ? "D" : (size < 60 ? "E" : (size < 100 ? "F" : (size < 150 ? "G" : (size < 300 ? "H" : (size < 600 ? "J" : "I"))))))));
        return letter;
    }

    public Map<String, String> phoneHome(Node node, boolean pretend) {
        PhoneHomeParameterCreator parameterCreator = this.createParameters(node);
        if (!pretend) {
            String urlStr = BASE_PHONE_HOME_URL + parameterCreator.build();
            this.fetchWebService(urlStr);
        }
        return parameterCreator.getParameters();
    }

    public PhoneHomeParameterCreator createParameters(Node hazelcastNode) {
        ClusterServiceImpl clusterService = hazelcastNode.getClusterService();
        int clusterSize = clusterService.getMembers().size();
        Long clusterUpTime = clusterService.getClusterClock().getClusterUpTime();
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        JetBuildInfo jetBuildInfo = hazelcastNode.getBuildInfo().getJetBuildInfo();
        PhoneHomeParameterCreator parameterCreator = new PhoneHomeParameterCreator().addParam("version", this.buildInfo.getVersion()).addParam("m", hazelcastNode.getThisUuid().toString()).addParam("p", this.getDownloadId()).addParam("c", clusterService.getClusterId().toString()).addParam("crsz", this.convertToLetter(clusterSize)).addParam("cssz", this.convertToLetter(hazelcastNode.clientEngine.getClientEndpointCount())).addParam("cuptm", Long.toString(clusterUpTime)).addParam("nuptm", Long.toString(runtimeMxBean.getUptime())).addParam("jvmn", runtimeMxBean.getVmName()).addParam("jvmv", System.getProperty("java.version")).addParam("jetv", jetBuildInfo == null ? "" : jetBuildInfo.getVersion());
        this.addClientInfo(hazelcastNode, parameterCreator);
        this.addOSInfo(parameterCreator);
        return parameterCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDownloadId() {
        InputStream is;
        String downloadId;
        block4: {
            downloadId = "source";
            is = null;
            try {
                is = this.getClass().getClassLoader().getResourceAsStream("hazelcast-download.properties");
                if (is == null) break block4;
                Properties properties = new Properties();
                properties.load(is);
                downloadId = properties.getProperty("hazelcastDownloadId");
            }
            catch (IOException ignored) {
                try {
                    EmptyStatement.ignore(ignored);
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(is);
                    throw throwable;
                }
                IOUtil.closeResource(is);
            }
        }
        IOUtil.closeResource(is);
        return downloadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchWebService(String urlStr) {
        BufferedInputStream in = null;
        try {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            conn.setConnectTimeout(2000);
            conn.setReadTimeout(2000);
            in = new BufferedInputStream(conn.getInputStream());
            IOUtil.closeResource(in);
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    private void addOSInfo(PhoneHomeParameterCreator parameterCreator) {
        OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            parameterCreator.addParam("osn", osMxBean.getName()).addParam("osa", osMxBean.getArch()).addParam("osv", osMxBean.getVersion());
        }
        catch (SecurityException e) {
            parameterCreator.addParam("osn", "N/A").addParam("osa", "N/A").addParam("osv", "N/A");
        }
    }

    private void addClientInfo(Node hazelcastNode, PhoneHomeParameterCreator parameterCreator) {
        Map<String, Integer> clusterClientStats = hazelcastNode.clientEngine.getConnectedClientStats();
        parameterCreator.addParam("ccpp", Integer.toString(clusterClientStats.getOrDefault("CPP", 0))).addParam("cdn", Integer.toString(clusterClientStats.getOrDefault("CSP", 0))).addParam("cjv", Integer.toString(clusterClientStats.getOrDefault("JVM", 0))).addParam("cnjs", Integer.toString(clusterClientStats.getOrDefault("NJS", 0))).addParam("cpy", Integer.toString(clusterClientStats.getOrDefault("PYH", 0))).addParam("cgo", Integer.toString(clusterClientStats.getOrDefault("GOO", 0)));
    }

    private void checkClusterSizeAndSetLicense(int clusterSize, PhoneHomeParameterCreator parameterCreator) {
        if (clusterSize <= 2) {
            parameterCreator.addParam("mclicense", "MC_LICENSE_NOT_REQUIRED");
        } else {
            parameterCreator.addParam("mclicense", "MC_LICENSE_REQUIRED_BUT_NOT_SET");
        }
    }

    public static class PhoneHomeParameterCreator {
        private final StringBuilder builder;
        private final Map<String, String> parameters = new HashMap<String, String>();
        private boolean hasParameterBefore;

        public PhoneHomeParameterCreator() {
            this.builder = new StringBuilder();
            this.builder.append("?");
        }

        Map<String, String> getParameters() {
            return this.parameters;
        }

        public PhoneHomeParameterCreator addParam(String key, String value) {
            if (this.hasParameterBefore) {
                this.builder.append("&");
            } else {
                this.hasParameterBefore = true;
            }
            try {
                this.builder.append(key).append("=").append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw ExceptionUtil.rethrow(e);
            }
            this.parameters.put(key, value);
            return this;
        }

        String build() {
            return this.builder.toString();
        }
    }
}

