/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.countdownlatch;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.countdownlatch.AwaitInvocationKey;
import com.hazelcast.cp.internal.datastructures.countdownlatch.CountDownLatch;
import com.hazelcast.cp.internal.datastructures.countdownlatch.CountDownLatchRegistry;
import com.hazelcast.cp.internal.datastructures.countdownlatch.proxy.CountDownLatchProxy;
import com.hazelcast.cp.internal.datastructures.spi.blocking.AbstractBlockingService;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.spi.impl.NodeEngine;
import java.util.Collection;
import java.util.UUID;

public class CountDownLatchService
extends AbstractBlockingService<AwaitInvocationKey, CountDownLatch, CountDownLatchRegistry> {
    public static final String SERVICE_NAME = "hz:raft:countDownLatchService";

    public CountDownLatchService(NodeEngine nodeEngine) {
        super(nodeEngine);
    }

    public boolean trySetCount(CPGroupId groupId, String name, int count) {
        return ((CountDownLatchRegistry)this.getOrInitRegistry(groupId)).trySetCount(name, count);
    }

    public int countDown(CPGroupId groupId, String name, UUID invocationUuid, int expectedRound) {
        CountDownLatchRegistry registry = (CountDownLatchRegistry)this.getOrInitRegistry(groupId);
        BiTuple<Integer, Collection<AwaitInvocationKey>> t = registry.countDown(name, invocationUuid, expectedRound);
        this.notifyWaitKeys(groupId, name, (Collection)t.element2, true);
        return (Integer)t.element1;
    }

    public boolean await(CPGroupId groupId, String name, AwaitInvocationKey key, long timeoutMillis) {
        boolean success = ((CountDownLatchRegistry)this.getOrInitRegistry(groupId)).await(name, key, timeoutMillis);
        if (!success) {
            this.scheduleTimeout(groupId, name, key.invocationUid(), timeoutMillis);
        }
        return success;
    }

    public int getRemainingCount(CPGroupId groupId, String name) {
        return ((CountDownLatchRegistry)this.getOrInitRegistry(groupId)).getRemainingCount(name);
    }

    public int getRound(CPGroupId groupId, String name) {
        return ((CountDownLatchRegistry)this.getOrInitRegistry(groupId)).getRound(name);
    }

    @Override
    protected CountDownLatchRegistry createNewRegistry(CPGroupId groupId) {
        return new CountDownLatchRegistry(groupId);
    }

    @Override
    protected Object expiredWaitKeyResponse() {
        return false;
    }

    @Override
    protected String serviceName() {
        return SERVICE_NAME;
    }

    public ICountDownLatch createProxy(String proxyName) {
        try {
            proxyName = RaftService.withoutDefaultGroupName(proxyName);
            RaftService service = (RaftService)this.nodeEngine.getService("hz:core:raft");
            RaftGroupId groupId = service.createRaftGroupForProxy(proxyName);
            return new CountDownLatchProxy(this.nodeEngine, groupId, proxyName, RaftService.getObjectNameForProxy(proxyName));
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

