/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

public final class EntryListCodec {
    private EntryListCodec() {
    }

    public static <K, V> void encode(ClientMessage clientMessage, Collection<Map.Entry<K, V>> collection, BiConsumer<ClientMessage, K> encodeKeyFunc, BiConsumer<ClientMessage, V> encodeValueFunc) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (Map.Entry<K, V> entry : collection) {
            encodeKeyFunc.accept(clientMessage, entry.getKey());
            encodeValueFunc.accept(clientMessage, entry.getValue());
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static <K, V> void encodeNullable(ClientMessage clientMessage, Collection<Map.Entry<K, V>> collection, BiConsumer<ClientMessage, K> encodeKeyFunc, BiConsumer<ClientMessage, V> encodeValueFunc) {
        if (collection == null) {
            clientMessage.add(ClientMessage.NULL_FRAME.copy());
        } else {
            EntryListCodec.encode(clientMessage, collection, encodeKeyFunc, encodeValueFunc);
        }
    }

    public static <K, V> List<Map.Entry<K, V>> decode(ClientMessage.ForwardFrameIterator iterator, Function<ClientMessage.ForwardFrameIterator, K> decodeKeyFunc, Function<ClientMessage.ForwardFrameIterator, V> decodeValueFunc) {
        ArrayList<Map.Entry<K, V>> result = new ArrayList<Map.Entry<K, V>>();
        iterator.next();
        while (!CodecUtil.nextFrameIsDataStructureEndFrame(iterator)) {
            K key = decodeKeyFunc.apply(iterator);
            V value = decodeValueFunc.apply(iterator);
            result.add(new AbstractMap.SimpleEntry<K, V>(key, value));
        }
        iterator.next();
        return result;
    }

    public static <K, V> List<Map.Entry<K, V>> decodeNullable(ClientMessage.ForwardFrameIterator iterator, Function<ClientMessage.ForwardFrameIterator, K> decodeKeyFunc, Function<ClientMessage.ForwardFrameIterator, V> decodeValueFunc) {
        return CodecUtil.nextFrameIsNullEndFrame(iterator) ? null : EntryListCodec.decode(iterator, decodeKeyFunc, decodeValueFunc);
    }
}

