/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.client.cache.impl.HazelcastClientCachingProvider;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.util.ExceptionUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import javax.cache.CacheManager;

public final class SpringHazelcastCachingProvider {
    private SpringHazelcastCachingProvider() {
    }

    public static CacheManager getCacheManager(HazelcastInstance instance, String uriString, Properties props) {
        URI uri = null;
        if (uriString != null) {
            try {
                uri = new URI(uriString);
            }
            catch (URISyntaxException e) {
                throw ExceptionUtil.rethrow((Throwable)e);
            }
        }
        if (instance instanceof HazelcastClientProxy) {
            return new HazelcastClientCachingProvider(instance).getCacheManager(uri, null, props);
        }
        return new HazelcastServerCachingProvider(instance).getCacheManager(uri, null, props);
    }

    public static CacheManager getCacheManager(String uriString, Properties properties) {
        String instanceName = properties.getProperty("hazelcast.instance.name");
        if (instanceName == null) {
            throw new IllegalStateException("Either 'instance-ref' attribute or hazelcast.instance.name property is required for creating cache manager");
        }
        return SpringHazelcastCachingProvider.getCacheManager(Hazelcast.getHazelcastInstanceByName((String)instanceName), uriString, properties);
    }
}

